/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/FrozenEnumEditor
 */
define(['mobile/fieldeditors/mobile/EnumEditor'], function (EnumEditor) {

  'use strict';

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/FrozenEnumEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */

  var FrozenEnumEditor = function FrozenEnumEditor() {
    EnumEditor.apply(this, arguments);
  };
  FrozenEnumEditor.prototype = Object.create(EnumEditor.prototype);
  FrozenEnumEditor.prototype.constructor = FrozenEnumEditor;

  FrozenEnumEditor.prototype.doRead = function () {
    var select = this.jq().find('select'),
        frozenEnum = this.value();

    return frozenEnum.get(Number(select.val()));
  };

  return FrozenEnumEditor;
});
