/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @private
 * @module mobile/fieldeditors/mobile/BooleanCheckboxEditor
 */
define(['baja!', 'jquery', 'mobile/fieldeditors/MobileFieldEditor', 'mobile/util/mobile/mobile'], function (baja, $, MobileFieldEditor, mobileUtil) {

  'use strict';

  var encodePageId = mobileUtil.encodePageId;

  /**
   * @private
   * @class
   * @alias module:mobile/fieldeditors/mobile/BooleanCheckboxEditor
   * @extends module:mobile/fieldeditors/MobileFieldEditor
   */

  var BooleanCheckboxEditor = function BooleanCheckboxEditor() {
    MobileFieldEditor.apply(this, arguments);
  };
  BooleanCheckboxEditor.prototype = Object.create(MobileFieldEditor.prototype);
  BooleanCheckboxEditor.prototype.constructor = BooleanCheckboxEditor;

  /**
   * @param {JQuery} dom
   */
  BooleanCheckboxEditor.prototype.doInitialize = function (dom) {
    var l = this.label,
        escaped = encodePageId(l),
        fieldset = $('<fieldset data-role="controlgroup"/>'),
        label = $('<label/>').attr('for', escaped).text(l),
        checkbox = $('<input type="checkbox" data-theme="b"/>').attr('name', escaped).attr('id', escaped);

    fieldset.append(checkbox).append(label);
    dom.append(fieldset);
  };

  BooleanCheckboxEditor.prototype.doLoad = function (value) {
    this.jq().find('input').attr('checked', value).checkboxradio('refresh');
  };

  BooleanCheckboxEditor.prototype.doRead = function () {
    return this.jq().find('input').is(':checked');
  };

  return BooleanCheckboxEditor;
});
