/**
 * @file Mobile-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - Pages
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Functions related to the management and display of JQM
 * dialog boxes.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available commands" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file A view to take up an entire JQM page.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file ORD-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to navbar management in Niagara apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The base ViewManager class, used for management of and
 * navigation between views.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A manager for navigating back and forth between PageViews.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam and Gareth Johnson
 */

/**
 * @file Start the alarm app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam and Gareth Johnson
 */

define("mobile/util/mobile/mobile",["baja!","jquery","jquerymobile","Promise"],function(e,t,n,o){"use strict";function i(e){return String(e).replace(/[&<>"'\/]/g,function(e){return j[e]})}function r(){n.loading("show")}function a(){n.loading("hide")}function c(e){var n=e.find(':jqmData(role="header")'),o=e.find(':jqmData(role="footer")'),i=window.innerHeight||t(window).height();return n.length&&(i-=n.outerHeight()),o.length&&(i-=o.outerHeight()),i}function u(e,t){var n=t||e.children(':jqmData(role="content")'),o=c(e),i=n.outerHeight()-n.height();n.height(o-i),n.parent().height(Math.max(n.parent().height(),o)),setTimeout(function(){n.trigger("updatelayout")},100)}function l(e,n,o){e.on(n,o);var i=t._data(e[0]),r=i.events,a=r[n];a.length>1&&a.splice(0,0,a.pop())}function s(t,n,o){var i=this;i.$ticket=setTimeout(function(){i.$ticket&&r()},t),n&&(i.$timeoutTicket=setTimeout(function(){if(i.$ticket){var t="timeout "+n+"ms reached";"function"==typeof o?o(t):e.error(t)}i.hide()},n))}function d(e,t,n){return new s(e||1e3,t,n)}function f(e,t){e.toggleClass("ui-listview-inset ui-corner-all ui-shadow",t);var n=e.children("li"),o=n.first(),i=n.last();o.toggleClass("ui-corner-top",t),i.toggleClass("ui-corner-bottom",t),o.children("a").last().toggleClass("ui-corner-tr",t),i.children("a").last().toggleClass("ui-corner-br",t)}function p(e){f(e,!0)}function g(e){f(e,!1)}function h(e){e.on("click","a",function(){var e=t(this);setTimeout(function(){e.removeClass(function(e,t){return"ui-btn-active "+(t.match(/\bui-btn-hover-\w/g)||[]).join(" ")})},100)})}function v(e){return e=String(e),"#"===e.charAt(0)&&(e=e.substring(1)),e.replace(k,function(e){return"_"+e.charCodeAt(0).toString(16).toUpperCase()})}function m(e){if(!e)return e;e=e instanceof t?e.attr("id"):String(e);var n=/\_([A-Z0-9][A-Z0-9])/g;return e=e.replace(n,function(e){return String.fromCharCode(parseInt(e.substring(1,e.length),16))}),unescape(e)}function y(t){var n=t&&t.viewQuery;return n||(t=e.objectify(t,"viewQuery"),n=t.viewQuery),"string"==typeof n||n&&n.id?n=new e.ViewQuery(n):!n&&t.id&&(n=new e.ViewQuery(t)),t.viewQuery=n,t}function b(t,n){n=y(n);var o;o=n.viewQuery?e.Ord.make({base:t,child:n.viewQuery}):e.Ord.make(t),window.location.assign(o.toUri())}function w(n,o){o=y(o);var i;i=o.viewQuery?e.Ord.make({base:n,child:o.viewQuery}):e.Ord.make(n),t.mobile.changePage(i.toUri(),o)}function P(n,i){var r=d(1e3);return o.resolve(t.ajax({url:e.Ord.make(n).toUri(),type:"POST",headers:{"niagara-mobile-rpc":"typeSpec"}})).then(function(e){return r.hide(),e.typeSpec===niagara.view.typeSpec?w(n,i):b(n,i)},function(e){return r.hide(),b(n,i)})}function C(e,t){O().pagecontainer("change",e,t)}function O(){return t(":mobile-pagecontainer")}function $(){return O().pagecontainer("getActivePage")}function D(e){O().length?e():t(window).one("pagecontainercreate",e)}var k=/[^\w-_]/g,j={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};return s.prototype.hide=function(){a();var e=this;clearTimeout(e.$ticket),delete e.$ticket,clearTimeout(e.$timeoutTicket),delete e.$timeoutTicket},{applyListviewInset:p,changePage:C,decodePageId:m,encodePageId:v,escapeHtml:i,getActivePage:$,getPageContainer:O,getVisibleHeight:c,hidePageLoadingMsg:a,linkToOrd:P,linkToOrdExternal:b,linkToOrdInternal:w,onPageContainerCreate:D,prependEventHandler:l,preventNavbarHighlight:h,removeListviewInset:g,setContentHeight:u,showPageLoadingMsg:r,spinnerTicket:d}}),define("mobile/util/mobile/pages",["baja!","jquery","jquerymobile","mobile/util/mobile/mobile"],function(e,t,n,o){"use strict";function i(e,t){1===arguments.length&&(t=e,e=I);var n=e;return"string"==typeof n&&(n=function(t){return e===t}),x.push({isMatch:n,handler:t}),t}function r(e){if(!e)return null;var t;for(t=0;t<x.length;++t)if(x[t].isMatch(e))return x[t].handler;return null}function a(e){var t=e.page.attr("id")||I,n=r(t);n&&"function"==typeof n[e.eventName]&&n[e.eventName](e)}function c(t){t=e.objectify(t,"eventName");var n;for(n=0;n<x.length;++n)"function"==typeof x[n].handler[t.eventName]&&x[n].handler[t.eventName](t)}function u(){return j.attr("id")||""}function l(){return r(u())}function s(){return j}function d(){return N.attr("id")||""}function f(){return N}function p(){return r(d())}function g(){return k}function h(e,n){var o,i=n.toPage;n&&n.prevPage&&(o=t(n.prevPage)),j||(o=i),a({page:i,prevPage:o,event:e,eventName:"pageshow"}),"dialog"!==i.jqmData("role")&&(j=N,N=i)}function v(e,n){var o,i=t(e.target);i&&(n&&n.prevPage&&(o=t(n.prevPage)),j||(o=i),a({page:i,prevPage:o,event:e,eventName:e.type}))}function m(e,n){var o;n&&n.nextPage&&(o=t(n.nextPage)),a({page:N,nextPage:o,event:e,eventName:"pagehide"})}function y(e,n){k=!1;var o;n&&n.nextPage&&(o=t(n.nextPage)),a({page:N,nextPage:o,event:e,eventName:e.type})}function b(e,n){a({page:t(e.target),event:e,eventName:e.type})}function w(e){return e=decodeURI(e),"/"!==e.charAt(0)&&"#"!==e.charAt(0)||(e=e.substring(1)),e.match(/^ord[\?\/]/)?"ord?"+encodeURI(e.substring(4)):encodeURI(e)}function P(e){return S(w(e))}function C(e,t,n){if(!e||"function"!=typeof e.createPage)throw new Error("No page handler (or no createPage function) found for id "+t);e.createPage(n)}function O(n,o){if(!V){var i,a=r(n),c=q();V=!0,o.pageData&&a&&"function"==typeof a.encodeUrl&&(n=a.encodeUrl(o.pageData)),i=P(n),c.children("#"+i).length||C(a,i,t.extend(o,{ok:function(e){e.attr("id",i),c.append(e),e.jqmData("pageData",o.pageData),e.page(),V=!1,t.mobile.changePage(e,o)},fail:function(t){V=!1,e.fail(t)}}))}}function $(n,o){if("string"==typeof o.toPage){var i,c,u,l=t.mobile.path.parseUrl(o.toPage),s=w(l.pathname+l.search),d=w(l.hash||""),f=w(l.pathname||""),p=d,g=q();if(!(d.indexOf("&ui-state=dialog")>-1)&&(i=r(p),i||(p=f,i=r(p)),i||(p=s,i=r(p)),i)){if(c=g.children("#"+P(p)),!c.length&&d&&(c=g.children("#"+P(d))),c.length||(c=g.children("#"+P(s))),d&&c.length||(o.options.dataUrl="/"+s),!c.length){if("function"!=typeof i.createPage)return;u=i.decodeUrl&&i.decodeUrl(l),o.options.pageData=u,o.options.url=l,e.started(function(){O(p,o.options)})}o.options.role&&"dialog"===o.options.role||c.is(".ui-dialog")||(c.length&&t.mobile.changePage(c,o.options),n.preventDefault())}}else if(o.toPage instanceof t){if(o.consumed)return;o.consumed=!0,"dialog"!==o.toPage.jqmData("role")&&(o.options.fromPage&&"dialog"!==o.options.fromPage.jqmData("role")&&a({page:o.options.fromPage,nextPage:o.toPage,event:n,eventName:"pagebeforechange",options:o.options}),n.isDefaultPrevented()||setTimeout(function(){o.toPage.trigger("pagelayout")},0))}}function D(){var e=q();e.on("pagebeforecreate pagecreate pageinit pagelayout","div",b).on("pagecontainershow",h).on("pagebeforeshow","div",v).on("pagecontainerhide",m).on("pagebeforehide","div",y),e.on("pagecontainerbeforechange",$)}var k=!0,j=null,N=null,x=[],V=!1,S=o.encodePageId,q=o.getPageContainer,H=o.onPageContainerCreate,I="____DEFAULT_PAGE_$_$";return H(D),{register:i,getPrevName:u,getPrev:s,getPrevHandler:l,getCurrentName:d,getCurrent:f,getCurrentHandler:p,getHandler:r,fire:a,fireAll:c,isFirst:g}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_slicedToArray=function(){function e(e,t){var n=[],o=!0,i=!1,r=void 0;try{for(var a,c=e[Symbol.iterator]();!(o=(a=c.next()).done)&&(n.push(a.value),!t||n.length!==t);o=!0);}catch(e){i=!0,r=e}finally{try{!o&&c.return&&c.return()}finally{if(i)throw r}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/util/mobile/dialogs",["baja!","lex!mobile","jquery","jquerymobile","Promise","mobile/util/mobile/pages","mobile/util/mobile/mobile","css!mobile/util/mobile/dialogs"],function(e,t,n,o,i,r,a){"use strict";function c(t,o){return t instanceof n?(o.html(t),i.resolve()):"object"===(void 0===t?"undefined":_typeof(t))||"string"==typeof t?(t instanceof Error&&e.error(t),o.text(String(t)),i.resolve()):"function"==typeof t?i.try(function(){return t(o.empty())}):void 0}function u(e){var t=r.getCurrent();return"string"==typeof e&&(e=f(e),e=n("#"===e.charAt(0)?e:"#"+e)),!t||!e||t[0]!==e[0]}function l(t,o){var i=n(w.patternReplace({theme:"a"})),r=i.children(":jqmData(role=content)").children(".dialogButtons");return e.iterate(o,function(e,t){var o=n(P.patternReplace({value:e}));o.text(m.get({key:e,def:e})),o.appendTo(r)}),i.attr("id",t),0===t.indexOf("error")&&i.addClass("error"),i.appendTo(g()),i}var s=e.callbackify,d=a.decodePageId,f=a.encodePageId,p=a.getActivePage,g=a.getPageContainer,h=a.hidePageLoadingMsg,v=_slicedToArray(t,1),m=v[0],y={},b=void 0,w=void 0,P=void 0,C=!1;w='<div data-role="dialog" class="dynamicDialog" data-overlay-theme="b">\n<div class="dynamicDialogHeader" data-role="header" data-theme="a">\n<h1 class="title" />\n</div>\n<div class="dynamicDialogContent" data-role="content" data-theme="c">\n<div class="dialogDisplay"></div>\n<div class="dialogButtons" data-role="controlgroup" data-type="horizontal"></div>\n</div>\n</div>',P='<a data-value="{value}" data-role="button" data-theme="a"></a>';var O=function(t,n){this.$params=e.objectify(t,"content"),this.$returnPage=t.returnPage,this.$page=n,C=!0};y.DialogInvocation=O,O.prototype.close=function(e){e=e||"cancel";var t=this,i=t.$options,r=t.$returnPage;"string"==typeof r&&0!==r.indexOf("ord?")&&"#"!==r.charAt(0)&&(r="#"+r),r instanceof n||"string"==typeof r?o.changePage(r,n.extend({transition:"none",changeHash:u(r)},i)):"function"==typeof r?r.call(this,e):o.changePage(location.href,{transition:"none",changeHash:!1}),b=void 0},O.prototype.invoke=function(t,n){function o(e){C=!1,u.fail(e),n.fail(e),C||a.close(t)}var i=e.ok,r=y.error;n=s(n,i,r);var a=this,c=a.$params,u=s(c.callbacks,i,r),l="function"==typeof t?t:c[t];"function"!=typeof l&&(l=function(e){e.ok()});try{C=!1,l.call(a,{ok:function(){C||a.close(t),u.ok(),n.ok()},fail:o})}catch(e){o(e)}},O.prototype.redirect=function(e,t){this.$returnPage=e,this.$options=t||{}},O.prototype.load=function(){var e=this,t=e.$page,o=e.$params,i=t.find(":jqmData(role=header)"),r=t.find(":jqmData(role=content)"),a=r.children(".dialogDisplay"),u=i.find("a:jqmData(icon=delete)"),l=r.find(".dialogButtons a");return i.find("h1.title").text(o.title||""),l.off("click").addClass("ui-disabled"),u.off().on("click",function(){return e.invoke("cancel"),!1}),c(o.content||"",a).then(function(){l.on("click",function(){var t=n(this).jqmData("value");e.invoke(t)}),l.removeClass("ui-disabled"),y.repositionDialog(t)},function(e){y.error("Failed to load dynamic dialog content: "+e)})},y.repositionDialog=function(e){var t=e.children(".ui-dialog-contain"),o=e.find(":jqmData(role=header)"),i=t.outerHeight(),r=n(window).height(),a=(r-i)/2,c=Math.max(a,15);t.css("margin-top",c),o.css("margin-top",c)},y.closeCurrent=function(){b&&b.close()},y.registerDialog=function(e,t){function i(e){b?b.load():e.page.find(".dialogDisplay").empty()}function a(i){var r=n("#"+e);return r.length||(r=l(e,t)),i.returnPage=b&&b.$returnPage||i.returnPage,b=new O(i,r),o.changePage(r,{changeHash:!1,allowSamePageTransition:!0,transition:"none"}),b}var c;c={load:a,pagebeforeshow:i},r.register(e,c)},function(){var e=y.registerDialog;e("yesNoCancelDialog",["yes","no","cancel"]),e("yesNoDialog",["yes","no"]),e("okCancelDialog",["ok","cancel"]),e("okDialog",["ok"]),e("errorDialog",["ok"]),e("cancelDialog",["cancel"])}();var $=function(e,t){return r.getHandler(e).load(t)};return y.yesNoCancel=function(e){return $("yesNoCancelDialog",e)},y.ok=function(e){return $("okDialog",e)},y.okCancel=function(e){return $("okCancelDialog",e)},y.cancel=function(e){return $("cancelDialog",e)},y.yesNo=function(e){return $("yesNoDialog",e)},y.error=function(t,n){return n=n||function(e){e.ok()},"function"!=typeof t&&e.error(t),h(),$("errorDialog",{title:m.get("appError"),content:t,ok:n})},y.unrecoverableError=function(t){var o,i=function(){location.reload()};return"function"==typeof t?o=t:(o=function(e){var o=n("<div/>").css({"margin-bottom":"1em"}).text(String(t)),i=n("<div/>").text(m.get("message.clickOKToReload"));e.append(o),e.append(i)},e.error(t)),h(),$("errorDialog",{title:m.get("unrecoverableError"),content:o,ok:i})},y.confirmAbandonChanges=function(t){t=e.objectify(t);var n=function(e){e.ok()},o=t.yes||n,i=t.no||n,a=t.redirect;return t.title=m.get("abandonChanges"),t.content=m.get({key:"message.confirmUnsavedChanges",args:[t.viewName]}),t.returnPage||(t.returnPage=d(r.getCurrent())),t.yes=function(e){a&&this.redirect(a),o.call(this,e)},t.no=function(e){a&&this.redirect(a),i.call(this,e)},y.yesNoCancel(t)},y.showDialog=function(e,t){var n=r.getHandler(e);return n?n.load(t):y.error(m.get({key:"dialogs.noPageRegistered",args:[e]}))},function(){n(window).on("resize",e.throttle(function(){var e=p();"dialog"===e.jqmData("role")&&y.repositionDialog(e)},500))}(),function(){var t=window.location.hash;t.indexOf("&ui-state=dialog")>0&&e.started(function(){o.changePage(t.replace("&ui-state=dialog",""),{changeHash:!0,transition:"none"})})}(),y}),define("mobile/util/mobile/commands",["require","css!mobile/util/mobile/commands","jquerymobile","baja!","jquery","Promise","underscore","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/mobile","lex!mobile"],function(e){"use strict";function t(){return g($.patternReplace({title:P.get("menu")}))}function n(e,t,n){if(e=v.filter(e,function(e){return e.isEnabled()}),g("a.commandsButton").trigger("onShowCommands",e),n=C(n),t=t||P.get("commands.title"),0===e.length)y.ok({title:t,content:P.get("commands.noneAvailable")});else var o=y.cancel({title:t,content:function(t){var n=v.map(e,function(e){var t=g("<li/>"),n=g("<a/>").appendTo(t);return e.toDisplayName().then(function(i){return n.text(i),n.click(function(){o.invoke(function(t){e.invoke().then(t.ok,t.fail)})}),t})});return h.all(n).then(function(e){var n=g('<ul data-role="listview" data-theme="c" />').html(e);t.html(n),n.listview()})},callbacks:n})}function o(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){O.contains(e)||O.push(e)})}function i(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){O.contains(e)||(O.length?O.splice(0,0,e):O.push(e))})}function r(e){var t=Array.prototype.slice.call(arguments);t.length>1?p.iterate(t,function(e){r(e)}):p.iterate(O,function(t,n){if(t===e)return O.splice(n,1),!0})}function a(){return O.slice(0)}function c(e){O=e}function u(){var e=a(),t=b.getCurrentHandler();return t&&"function"==typeof t.getCommands&&(e=t.getCommands({commands:e,page:b.getCurrent()})),n(e),!1}function l(){return d}function s(){return f}e("css!mobile/util/mobile/commands"),e("jquerymobile");var d,f,p=e("baja!"),g=e("jquery"),h=e("Promise"),v=e("underscore"),m=e("bajaux/commands/Command"),y=e("mobile/util/mobile/dialogs"),b=e("mobile/util/mobile/pages"),w=e("mobile/util/mobile/mobile"),P=e("lex!mobile")[0],C=p.callbackify,O=[],$="<a class='commandsButton profileHeader' title='{title}' data-icon='bars' data-role='button' data-iconpos='notext'></a>";return f=new m("%lexicon(mobile:commands.logout)%",function(e){var t=location.protocol+"//"+location.host+"/logout";window.location.assign(t+"?csrfToken="+encodeURIComponent(g("#csrfToken").val()))}),"undefined"!=typeof niagara&&niagara.view.profile.showLogoutCmd&&i(f),d=new m("%lexicon(mobile:commands.home)%",function(e){w.linkToOrd(p.getUserHome())}),"undefined"!=typeof niagara&&niagara.view.profile.showHome&&i(d),{getCommandsButton:t,getHomeCmd:l,getLogoutCmd:s,showCommandsDialog:n,addDefaultCommand:o,prependDefaultCommand:i,removeDefaultCommand:r,getDefaultCommands:a,setDefaultCommands:c,showCommandsHandler:u}}),define("mobile/util/mobile/views/PageView",["baja!","bajaux/Widget","jquery","jquerymobile","Promise","css!mobile/util/mobile/views/PageView"],function(e,t,n,o,i){"use strict";var r=function(n){t.call(this,"mobile","PageView"),n=e.objectify(n,"contentViewConstructor"),this.contentViewConstructor=n.contentViewConstructor,this.$title=n.title,this.$ignoreProfileClasses=""};return r.prototype=Object.create(t.prototype),r.prototype.constructor=r,r.prototype.ignoreProfileClasses=function(e){this.$ignoreProfileClasses=e||""},r.prototype.createPage=function(){var e=n('<div class="ux-fullscreen-support" data-role="page" data-theme="c" />'),t=n('<div data-role="header" data-position="fixed" data-tap-toggle="false" data-theme="a" />').appendTo(e),o=n('<a href="#" class="profileHeader profileHeaderBack" data-rel="back" data-icon="arrow-l" data-iconpos="notext"></a>').appendTo(t),i=n('<h1 class="profileHeader viewName"/>').appendTo(t);return n('<div data-role="content" class="ux-root ux-fullscreen"/>').appendTo(e),o.removeClass(this.$ignoreProfileClasses),i.removeClass(this.$ignoreProfileClasses),e},r.prototype.toDisplayName=function(){return i.resolve(this.$title||this.contentView&&this.contentView.toDisplayName()||void 0)},r.prototype.getPage=function(){return this.jq()},r.prototype.getHeaderDiv=function(){return this.jq().children(":jqmData(role=header)")},r.prototype.getContentDiv=function(){return this.jq().children(":jqmData(role=content)")},r.prototype.getFooterDiv=function(){return this.jq().children(":jqmData(role=footer)")},r.prototype.getViewQuery=function(){return this.viewQuery},r.prototype.instantiateContentView=function(e){var t=this.contentViewConstructor;if(t)return new t;throw new Error("instantiateContentView not implemented")},r.prototype.isModified=function(){var e=this.contentView;return e&&e.isModified()},r.prototype.doInitialize=function(e){var t,n=this;if("page"!==e.jqmData("role"))throw new Error("PageView requires a JQM page (data-role='page')");t=e.data("pageData"),n.viewQuery=t&&t.viewQuery,n.pageId=e.attr("id")},r.prototype.doLoad=function(e){var t=this,n=t.contentView;return i.resolve(n&&n.destroy()).then(function(){n=t.contentView=t.instantiateContentView(e);var o=t.getPage().data("ord");return i.all([o?n.resolve(o):i.resolve(e),n.initialize(t.getContentDiv())])}).then(function(t){var o=t[0];return o.getType().is(e.getType())||(o=e),n.load(o)}).then(function(){return n.toDisplayName()}).then(function(e){t.getHeaderDiv().find("h1").text(e)})},r.prototype.destroy=function(){var e=this,n=e.contentView,o=arguments;return i.resolve(n&&n.destroy()).then(function(){return t.prototype.destroy.apply(e,o)})},r.prototype.save=function(e){var t=this;return t.contentView.save(e).then(function(e){return i.resolve(t.setModified(!1)).then(function(){return e})})},r.prototype.getCommandGroup=function(){return this.contentView.getCommandGroup()},r.prototype.doLayout=function(){return i.resolve(this.contentView&&this.contentView.layout())},r}),define("mobile/util/ord",["baja!"],function(e){"use strict";function t(e){if(!e)return"";e=String(e);var t=e.length,n=e.substring(t-1,t),o=e.substring(t-2,t-1);return"/"===n&&":"!==o?e=e.substring(0,t-1):":"===n&&(e+="/"),e}function n(t,n){return t=e.Ord.make(t),void 0===n&&(n=!0),t.get({lease:n})}function o(e){e=unescape(String(e)),e.match(/\/$/)&&(e=e.substring(0,e.length-1));var n=e.split("/"),o=0,i=[];for(o=0;o<n.length;o++)i.push(t(n.slice(0,o+1).join("/")));return i}function i(t,n){return!(!t||!n)&&e.Ord.make(t).relativizeToSession().equals(e.Ord.make(n).relativizeToSession())}function r(t){if(t){if(t instanceof e.Ord||"string"==typeof t)return t.toString();if(t.getType().isComponent()&&t.isMounted())return t.getNavOrd().relativizeToSession().toString();if(t.getType().isComplex()){var n=r(t.getParent());if(n)return n+"/"+t.getPropertyInParent()}}}return{chopLastSlash:t,deriveOrd:r,equivalent:i,get:n,makeOrdHistory:o}}),define("mobile/util/views/views",["baja!","lex!mobile"],function(e,t){"use strict";function n(t){if(t instanceof e.Complex)return t.getDisplayName()||t.getName()||o.get("propsheet.station")}var o=t[0];return{getComponentName:n}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/nav",["baja!","bajaux/Widget","Promise","underscore","mobile/util/views/views","mobile/util/ord","mobile/util/mobile/mobile"],function(e,t,n,o,i,r,a){"use strict";function c(n){return n instanceof s?n:n instanceof e.Ord||"string"==typeof n?new d(n):n instanceof t?new p(n):n instanceof e.Complex?new f(n):n&&"object"===(void 0===n?"undefined":_typeof(n))?new g(n):void 0}function u(e,t){return e?r.equivalent(e.getNavOrd(),t)?e:o.find(e.getNavChildren(),function(e){return u(e,t)}):null}var l=i.getComponentName,s=function(e){this.$navChildren=[],this.$value=e};s.prototype.getNavOrd=function(){return this.$navOrd},s.prototype.setNavOrd=function(e){this.$navOrd=e},s.prototype.getNavDescription=function(){return this.$navDescription},s.prototype.setNavDescription=function(e){this.$navDescription=e},s.prototype.getNavIcon=function(){return this.$navIcon},s.prototype.setNavIcon=function(e){this.$navIcon=e},s.prototype.getNavChildren=function(){return this.$navChildren},s.prototype.setNavChildren=function(e){this.$navChildren=e},s.prototype.getNavParent=function(){return this.$navParent},s.prototype.setNavParent=function(e){this.$navParent=e},s.prototype.getValue=function(){return this.$value},s.prototype.setValue=function(e){this.$value=e},s.prototype.toString=function(){return String(this.$navOrd)},s.prototype.toDisplayName=function(){return n.resolve(this.$navDescription)};var d=function(t){s.apply(this,arguments);var n=e.Ord.make(t),o=String(n),i=o.split("/");this.$navOrd=n,this.$navDescription=i[i.length-1]};d.prototype=Object.create(s.prototype),d.prototype.constructor=d;var f=function(e){s.apply(this,arguments),this.$navDescription=l(e),this.$navOrd=r.deriveOrd(e),this.$navIcon=e.getIcon()};f.prototype=Object.create(s.prototype),f.prototype.constructor=d;var p=function(t){s.apply(this,arguments);var n,o,i=t.value();this.$view=t,i instanceof e.Complex&&(n=r.deriveOrd(i),o=i.getIcon()),!n&&t.pageId&&(n=a.decodePageId(t.pageId),0===n.indexOf("ord?")&&(n=n.substring(4))),this.$navOrd=n,this.$navIcon=o};p.prototype=Object.create(s.prototype),p.prototype.constructor=p,p.prototype.toDisplayName=function(){var e=this,t=e.$displayName;return t?n.resolve(t):e.$view.toDisplayName().then(function(t){return e.$displayName=t,t})};var g=function(e){this.$navOrd=e.$navOrd,this.$navDescription=e.$navDescription,this.$navIcon=e.$navIcon,this.$navChildren=e.$navChildren||[],this.$navParent=e.$navParent,this.$value=e.$value};g.prototype=Object.create(s.prototype);var h=function(){this.$selectedNode=null,this.$nodes=[],this.$changeListeners=[],this.$cutListeners=[]};e.event.mixin(h.prototype),h.prototype.add=function(e){var t=c(e);return this.pruneOtherBranch(t),this.$nodes.push(t),this},h.prototype.cut=function(t){if(!t||this.indexOf(t)<0)return this;t=c(t);var n=this,o=n.next(t);return o&&n.cut(o),n.$nodes.pop(),n.fireHandlers("cut",e.error,this,t),n},h.prototype.getSelectedNode=function(){return this.$selectedNode},h.prototype.getSelectedIndex=function(){return this.indexOf(this.getSelectedNode())},h.prototype.setSelectedNode=function(t){t=c(t),this.indexOf(t)<0&&this.add(t),this.$selectedNode=t,this.fireHandlers("change",e.error,this)},h.prototype.getNodes=function(){return this.$nodes},h.prototype.getOrds=function(){var e=[];return this.each(function(t){e.push(t.getNavOrd())}),e},h.prototype.each=function(t){return e.iterate(this.$nodes,t)},h.prototype.isEmpty=function(){return 0===this.$nodes.length},h.prototype.first=function(){return this.get(0)},h.prototype.last=function(){return this.get(this.size()-1)},h.prototype.indexOf=function(e){if(!e)return-1;e=c(e);var t,n=this,o=e.getNavOrd();return t=n.each(function(e,t){var n=e.getNavOrd();if(r.equivalent(o,n))return t}),void 0===t?-1:t},h.prototype.get=function(e){return this.$nodes[e]},h.prototype.next=function(e){var t=this.indexOf(e);return t>=0?this.get(t+1):void 0},h.prototype.prev=function(e){var t=this.indexOf(e);return t>=0?this.get(t-1):void 0},h.prototype.size=function(){return this.$nodes.length},h.prototype.pruneOtherBranch=function(t){var n=this;n.isEmpty()||n.sameBranch(t,n.last())||e.iterate(1,this.size(),function(e){var o=n.get(e);if(!n.sameBranch(t,o))return n.cut(o)})},h.prototype.sameBranch=function(e,t){var n=decodeURIComponent(String(e.getNavOrd())),o=decodeURIComponent(String(t.getNavOrd()));return n=n.replace(/\/+/g,"/"),o=o.replace(/\/+/g,"/"),0===n.indexOf(o)||0===o.indexOf(n)};var v=function(){h.call(this)};v.prototype=Object.create(h.prototype),v.prototype.constructor=v,v.prototype.add=function(t){var n=this,o=c(t),i=n.$nodes,a={},u=[],l=o.getNavOrd(),s=r.makeOrdHistory(l);return n.pruneOtherBranch(o),e.iterate(0,s.length-1,function(e){if(!i[e]){var t=s[e],n=u.length;i[e]=c(t),a["ord"+n]={ord:t,origIndex:e},u.push(t)}}),u.length&&new e.BatchResolve(u).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];i[n.origIndex]=c(e)}),n.fireHandlers("change",e.error,this)},fail:e.error}),i[s.length-1]=o,n.fireHandlers("change",e.error,this),this};var m=function(){var t=this;h.call(t),t.$flattenedNavFile=void 0,e.nav.navfile.getRootNode()};return m.prototype=Object.create(h.prototype),m.prototype.constructor=m,m.prototype.makeNavFileOrdHistory=function(t){var n=this,o=r.makeOrdHistory(t),i=o.length,a=[],l=[];return e.iterate(0,i,function(e){var t=o[i-1-e],r=u(n.$flattenedNavFile,t);if(r){for(;r;)a.push(r),r=r.getNavParent();return!0}a.push(c(t))}),i=a.length,e.iterate(0,i,function(e){l.push(a[i-1-e])}),l},m.prototype.add=function(t){var n,o=c(t),i=this,a={},u=[],l=o.getNavOrd(),s=i.makeNavFileOrdHistory(l);return i.pruneOtherBranch(o),n=i.$nodes[s.length-1]||s[s.length-1],n&&n.$fromNavFile&&r.equivalent(n.getNavOrd(),o.getNavOrd())&&(o=n,o.setValue(t)),s[s.length-1]=o,i.$nodes.splice(0,s.length),i.$nodes=s.concat(i.$nodes),e.iterate(0,i.$nodes.length,function(t){var n=i.$nodes[t].getValue(),o=u.length;(n instanceof e.Ord||"string"==typeof n)&&(a["ord"+o]={ord:n,origIndex:t},u.push(n))}),u.length&&new e.BatchResolve(u).resolve({ok:function(){var t=this.getTargetObjects();e.iterate(t,function(e,t){var n=a["ord"+t];i.$nodes[n.origIndex]=c(e)}),i.fireHandlers("change",e.error,this)},fail:e.error}),i.fireHandlers("change",e.error,this),this},m.prototype.sameBranch=function(t,n){var o=this,i=t.getNavOrd(),a=n.getNavOrd(),c=o.makeNavFileOrdHistory(i),u=o.makeNavFileOrdHistory(a),l=c.length,s=u.length;return!e.iterate(0,Math.min(l,s),function(e){if(!r.equivalent(c[e],u[e]))return!0})},{NavModel:h,ComponentSpaceNavModel:v,NavFileNavModel:m}}),define("mobile/util/views/ViewManager",["baja!","bajaux/Widget","Promise"],function(e,t,n){"use strict";var o=function t(){e.callSuper(t,this,arguments),this.$selectedView=void 0};return o=e.subclass(o,t),o.prototype.loadView=function(e){return n.resolve()},o.prototype.getSelectedView=function(){return n.resolve(this.$selectedView)},o.prototype.setSelectedView=function(e){var n=this;return n.getSelectedView().then(function(o){e instanceof t&&e!==o&&(n.$selectedView=e)})},o}),define("mobile/util/mobile/views/PageViewManager",["baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/util/mobile/mobile","mobile/util/ord","mobile/util/nav","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/views/PageView","mobile/util/views/ViewManager"],function(e,t,n,o,i,r,a,c,u,l,s,d,f,p){"use strict";function g(e,t){var n,o,i,a=e,u=a.$selectedView;return!!(u&&(n=a.navModel.getOrds(),o=r.indexOf(n,c.deriveOrd(u.value())),(i=r.indexOf(n,t))>=0&&o>=0&&i<o))}var h,v=a.encodePageId,m=a.decodePageId,y=t[0];return h=e.subclass(function t(o){e.callSuper(t,this,["mobile","PageViewManager "]);var i=this;i.navModel=o||new u.NavModel,i.navModel.attach("cut",function(e){var t=e.getValue();t instanceof f&&(t.destroy(),n("#"+t.pageId).remove())}),window.onbeforeunload=function(){var e=i.$selectedView;if(e.isModified()){var t;return e.toDisplayName().then(function(e){t=e}),y.get({key:"message.viewModified",args:[t]})}},e.iterate(l.getDefaultCommands(),function(e){i.getCommandGroup().add(e)})},p),h.prototype.doResolveOrd=function(t){return e.Ord.make(t).get({lease:!0})},h.prototype.createPagesHandlers=function(){function t(t){var n,o=a.spinnerTicket(1e3,5e3),i=t.pageData,r=i.ord;s.doResolveOrd(r).then(function(e){return n=e,s.instantiateView(n,i)}).then(function(e){var o=e.createPage();o.jqmData("view",e),o.jqmData("value",n),o.jqmData("ord",r),t.ok(o)}).catch(e.error).finally(function(){o.hide()})}function n(e){return"/ord/"+(e.ord||"station:|slot")}function o(t){var n,o,i=decodeURI(t.pathname+t.search).replace("&ui-state=dialog","");return 0!==i.indexOf("/ord?")&&0!==i.indexOf("/ord/")?{ord:"station:|slot:"}:(n=i.substring(5),o=e.Ord.make(n).parse().get("view"),{ord:n,viewQuery:o})}function i(t){function n(t){s.addView(i,o,r,a).catch(e.error),o.off("pagelayout",n)}var o=t.page,i=o.jqmData("view"),r=o.jqmData("value"),a=o.jqmData("ord");o.on("pagelayout",n)}function r(e){var t=e.page,n=t.jqmData("view"),o=n.value(),i=o&&o.getType();i&&n.$layoutDone&&i.isComponent()&&i.is("baja:VirtualComponent")&&s.refresh(n),n.$layoutDone=!0}function c(t){var n=t.page,o=n.jqmData("view");o&&o.pageId&&(s.setSelectedView(o).catch(e.error),o.layout())}function u(e){var t,n=s.selectedView;n&&n.isModified()&&(t=m(e.nextPage.attr("id")),s.confirmAbandonChanges(t),e.event.preventDefault())}function l(e){return e.commands}var s=this;return{createPage:t,encodeUrl:n,decodeUrl:o,pagelayout:r,pageshow:c,pagecreate:i,pagebeforechange:u,getCommands:l}},h.prototype.registerPages=function(e){d.register(e||function(e){return e.match(/^ord/)},this.createPagesHandlers())},h.prototype.initializeView=function(e,t,n,o){var i=this;return e.initialize(t).then(function(){return e.load(n)}).then(function(){return i.armHandlers(e),i.attachSubscriberEvents(e),e})},h.prototype.instantiateView=function(e,t){return i.reject("instantiateView not implemented")},h.prototype.addView=function(e,t,n,o){var i=this;return i.initializeView(e,t,n,o).then(function(e){return i.navModel.add(e),i.setSelectedView(e).then(function(){return e})})},h.prototype.armHandlers=function(e){var t=this,o=e.jq();o.on("click","a.link",function(){t.linkToOrd(n(this).jqmData("ord"))}),o.on("click","a.commandsButton",function(){t.showCommands(e)})},h.prototype.showCommands=function(e){var t=e.getCommandGroup(),n=this.getCommandGroup(),o=t.merge(n,{mergeCommands:!1}).flatten({recurse:!0});l.showCommandsDialog(o)},h.prototype.attachSubscriberEvents=function(e){var t=this,o=t.navModel,i=e.contentView.getSubscriber&&e.contentView.getSubscriber();i&&(i.attach("renamed",function(t,o,i){var r=v(t.getName()),a=e.pageId+"_2F"+r,c=v(o),u=e.pageId+"_2F"+c;n("#"+u).attr("id",a)}),i.attach("unmount",function(){var n,i=o.prev(e),r=o.indexOf(i),a=o.indexOf(t.selectedView);a>r?(n=y.get({key:"propsheet.message.unmounted",def:'Component "{0}" has been unmounted.',args:[e.getDisplayName()]}),s.ok({content:n,ok:function(n){for(;i&&!i.getNavOrd();)i=o.prev(i),e=o.prev(e);var r=c.deriveOrd(i.getValue().value());r&&"null"!==r&&t.linkToOrdInternal(r),o.cut(e),n.ok()}})):o.cut(e)}))},h.prototype.confirmAbandonChanges=function(e){var t=this,n=this.$selectedView;return new i(function(o,i){n.isModified()?n.toDisplayName().then(function(r){return s.confirmAbandonChanges({yes:function(e){var r=this;n.save().then(function(){t.refresh(n).then(function(){o(),e.ok()},function(t){i(t),e.fail(t)})},function(t){r.redirect(m(n.pageId)),i(t),e.fail(t)})},no:function(e){n.setModified(!1),t.refresh(n).then(function(){o(),e.ok()},function(t){i(t),e.fail(t)})},viewName:r,redirect:e})}):o()})},h.prototype.save=function(e){return e.save()},h.prototype.saveSelected=function(){var e=this
;return e.getSelectedView().then(function(t){return e.save(t)})},h.prototype.setSelectedView=function(t){var o=this;return e.callSuper("setSelectedView",h,this,[t]).then(function(){return t.toDisplayName()}).then(function(e){var i;document.title=e,i=n("#"+t.pageId.replace(/(:|\.)/g,"\\$1")),i.children(":jqmData(role=header)").children("h1.viewName").text(e),o.currentPage=i,o.navModel.setSelectedNode(t)})},h.prototype.refresh=function(e){var t=this;return e.load(e.value()).then(function(){t.attachSubscriberEvents(e)})},h.prototype.refreshSelected=function(){var e=this;return e.getSelectedView().then(function(t){return t.isModified()?e.confirmAbandonChanges(void 0):e.refresh(t)})},h.prototype.linkToOrd=function(e,t){function n(){return a.linkToOrd(e,{viewQuery:t,reverse:g(o,e)})}var o=this;return o.getSelectedView().then(function(e){return e.isModified()?o.confirmAbandonChanges(n):n()})},h.prototype.linkToOrdInternal=function(t,n){n=e.objectify(n),n.reverse=g(this,t),a.linkToOrdInternal(t,n)},h.prototype.linkToOrdExternal=function(e,t){a.linkToOrdExternal(e,t)},h.prototype.layout=function(){return this.getSelectedView().then(function(e){if(e)return e.layout()})},h}),define("mobile/util/mobile/views/widgetViewUtil",["jquery","baja!","bajaux/Widget","Promise","underscore"],function(e,t,n,o,i){"use strict";var r={};return r.loadPageView=function(t){e(document).one("mobileinit",function(){e.mobile.autoInitializePage=!1}),require(["jquerymobile","mobile/util/mobile/commands","mobile/util/mobile/views/PageView","mobile/util/mobile/views/PageViewManager","mobile/util/mobile/pages","mobile/util/mobile/mobile"],function(n,r,a,c,u,l){var s,d=function(){a.call(this,{contentViewConstructor:function(){return t()}})};d.prototype=Object.create(a.prototype),d.prototype.constructor=d,d.prototype.createPage=function(){var e=a.prototype.createPage.apply(this,arguments);return e.children("[data-role=content]").css("padding",0),e.children("[data-role=header]").append(r.getCommandsButton()),e},d.prototype.initialize=function(){return this.$pageViewResizeHandler=i.debounce(function(){s&&s.layout()},200),e(window).on("resize",this.$pageViewResizeHandler),a.prototype.initialize.apply(this,arguments)},d.prototype.destroy=function(){return e(window).off("resize",this.$pageViewResizeHandler),this.$pageViewResizeHandler=null,a.prototype.destroy.apply(this,arguments)};var f=function(){c.apply(this,arguments)};f.prototype=Object.create(c.prototype),f.prototype.constructor=f,f.prototype.instantiateView=function(){return o.resolve(new d)},u.register({pageshow:function(){l.linkToOrdInternal(window.niagara.view.ord,{transition:"none",changeHash:!1})}}),s=new f,s.registerPages(),n.initializePage()})},r}),require(["Promise","mobile/util/mobile/views/widgetViewUtil","nmodule/alarm/rc/console/AlarmConsole","bajaux/Widget"],function(e,t,n,o){"use strict";t.loadPageView(function(){var t=new n("alarm","AlarmUxConsole",o.formfactor.max);return t.toDisplayName=function(){var t=this.value();return e.resolve(t&&t.getDisplayName())},t})}),define("mobile/alarm/alarm.run",function(){});