function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
* API Status: **Private**
* @module nmodule/bajaui/rc/ux/shape/Shape
*/
define(['baja!', 'baja!gx:Pen', 'bajaux/spandrel', 'Promise', 'nmodule/webEditors/rc/fe/fe'], function (baja, types, spandrel, Promise, fe) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-shape',
        fill: baja.$('gx:Brush', 'null'),
        stroke: baja.$('gx:Brush', 'null'),
        enabled: true,
        visible: true,
        pen: baja.$('gx:Pen')
      }
    };
  };

  return /*#__PURE__*/function (_spandrel) {
    _inherits(Shape, _spandrel);

    var _super = _createSuper(Shape);

    function Shape(params) {
      _classCallCheck(this, Shape);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }
    /**
     * Allow Shape implementation to return its content to append
     * 
     * @abstract
     * @returns {Element} to append to the base Shape
     */


    _createClass(Shape, [{
      key: "renderContents",
      value: function renderContents() {
        throw new Error('Not implemented');
      }
      /**
       * 
       * @returns {module:bajaux/Widget|undefined}
       */

    }, {
      key: "getShapeSvg",
      value: function getShapeSvg() {
        return this.queryWidget(0);
      }
      /**
       * Returns the transform element
       * 
       * @returns {Element}
       */

    }, {
      key: "getTransformEl",
      value: function getTransformEl() {
        return this.getShapeSvg().jq().children('g')[0];
      }
      /**
       * Get the shape element of this svg.
       * Returns the line, rect, path, etc svg element
       *
       * @abstract
       * @param {Element} element the element to search for the shape
       * @returns {Element}
       */

    }, {
      key: "getShapeEl",
      value: function getShapeEl(element) {
        throw new Error('Not implemented');
      }
      /**
       * Apply fill, stroke and pen properties to the shape.
       * Subclasses may override this to apply any specific properties applicable.
       * 
       * @param {Element} svg the svg element
       * @param {Element} shape the shape element
       *
       * @returns {Promise}
       */

    }, {
      key: "applyProps",
      value: function applyProps(svg, shape) {
        if (svg && shape) {
          var fill = this.properties().getValue('fill'),
              stroke = this.properties().getValue('stroke'),
              pen = this.properties().getValue('pen'),
              transformParams = this.$transformParams;
          return Promise.all([fill.applyFillToSvgElement(shape, svg, transformParams), stroke.applyStrokeToSvgElement(shape, svg, transformParams), pen.applyToSvgElement(shape)]);
        }

        return Promise.resolve();
      }
      /**
       * Apply shape attributes (again) giving a chance to styles like gradients that 
       * need a well laid out structure to work on.
       * 
       * @returns {Promise}
       * 
       */

    }, {
      key: "doLayout",
      value: function doLayout() {
        var svg = this.getShapeSvg(),
            svgElem = svg && svg.jq()[0],
            shape = this.getShapeEl(svgElem);

        if (svg && shape) {
          return this.applyProps(svgElem, shape);
        }
      }
    }]);

    return Shape;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
        rootElement = _ref.rootElement;
    var shapeSvg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
        transformSvg = document.createElementNS('http://www.w3.org/2000/svg', 'g');
    rootElement.classList.add('hxpx-graphics');
    shapeSvg.setAttribute('height', '100%');
    shapeSvg.setAttribute('width', '100%');
    transformSvg.setAttribute('transform', 'translate(0.5, 0.5)');
    var content = this.renderContents();
    var shape = this.getShapeEl(content);
    return this.applyProps(shapeSvg, shape).then(function () {
      shapeSvg.appendChild(transformSvg);
      transformSvg.appendChild(content);
      return shapeSvg;
    });
  }, {
    manager: fe.getWidgetManager()
  }));
});
