function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
* API Status: **Private**
* @module nmodule/bajaui/rc/ux/shape/Path
*/
define(['baja!', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/gx/rc/baja/Point', 'nmodule/gx/rc/baja/PathGeom'], function (baja, Shape, Point, PathGeom) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-shape-Path',
        geom: PathGeom.NULL
      }
    };
  };

  return /*#__PURE__*/function (_Shape) {
    _inherits(Path, _Shape);

    var _super = _createSuper(Path);

    function Path(params) {
      _classCallCheck(this, Path);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }

    _createClass(Path, [{
      key: "renderContents",
      value: function renderContents() {
        var geom = this.properties().getValue('geom'),
            path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        path.setAttribute('d', generatePathGeom(geom)); // Add mouse handler class

        path.setAttribute('class', 'hxpx-mouseHandler');
        return path;
      }
    }, {
      key: "getShapeEl",
      value: function getShapeEl(element) {
        return element.querySelector('path');
      }
    }]);

    return Path;
  }(Shape);
  /**
   * Generate the svg path geom to be painted
   * 
   * @param {gx:PathGeom} geom 
   */

  function generatePathGeom(geom) {
    var segs = geom.$getSegments();
    var lastPoint = Point.DEFAULT,
        lastControlPoint,
        newGeom = new PathGeom();
    segs.forEach(function (s) {
      switch (s.getCommand().toUpperCase()) {
        case 'Z':
          {
            newGeom.close();
            break;
          }

        case 'M':
          {
            var p = s.getPoint();
            var newX = p.x(),
                newY = p.y();

            if (s.getRelative()) {
              newX += lastPoint.x();
              newY += lastPoint.y();
            }

            newGeom.moveTo(true, newX, newY);
            lastPoint = new Point(newX, newY);
            lastControlPoint = lastPoint;
            break;
          }

        case 'L':
          {
            var _p = s.getPoint();

            var _newX = _p.x(),
                _newY = _p.y();

            if (s.getRelative()) {
              _newX += lastPoint.x();
              _newY += lastPoint.y();
            }

            newGeom.lineTo(true, _newX, _newY);
            lastPoint = new Point(_newX, _newY);
            break;
          }

        case 'C':
          {
            var cp1 = s.getCp1(),
                cp2 = s.getCp2(),
                _p2 = s.getEnd();

            var _newX2 = _p2.x(),
                _newY2 = _p2.y(),
                newX1 = cp1.x(),
                newY1 = cp1.y(),
                newX2 = cp2.x(),
                newY2 = cp2.y();

            if (s.getRelative()) {
              _newX2 += lastPoint.x();
              _newY2 += lastPoint.y();
              newX1 += lastPoint.x();
              newY1 += lastPoint.y();
              newX2 += lastPoint.x();
              newY2 += lastPoint.y();
            }

            newGeom.curveTo(true, newX1, newY1, newX2, newY2, _newX2, _newY2);
            lastPoint = new Point(_newX2, _newY2);
            lastControlPoint = new Point(newX2, newY2);
            break;
          }

        case 'S':
          {
            var _cp = lastPoint,
                _cp2 = s.getCp2(),
                _p3 = s.getEnd();

            var _newX3 = _p3.x(),
                _newY3 = _p3.y(),
                _newX4 = _cp.x(),
                _newY4 = _cp.y(),
                _newX5 = _cp2.x(),
                _newY5 = _cp2.y();

            if (lastControlPoint) {
              _newX4 += lastPoint.x() - lastControlPoint.x();
              _newY4 += lastPoint.y() - lastControlPoint.y();
            }

            if (s.getRelative()) {
              _newX3 += lastPoint.x();
              _newY3 += lastPoint.y();
              _newX5 += lastPoint.x();
              _newY5 += lastPoint.y();
            }

            newGeom.curveTo(true, _newX4, _newY4, _newX5, _newY5, _newX3, _newY3);
            lastPoint = new Point(_newX3, _newY3);
            lastControlPoint = new Point(_newX5, _newY5);
            break;
          }

        case 'Q':
          {
            var cp = s.getCp(),
                _p4 = s.getEnd();

            var _newX6 = _p4.x(),
                _newY6 = _p4.y(),
                _newX7 = cp.x(),
                _newY7 = cp.y();

            if (s.getRelative()) {
              _newX6 += lastPoint.x();
              _newY6 += lastPoint.y();
              _newX7 += lastPoint.x();
              _newY7 += lastPoint.y();
            }

            newGeom.quadTo(true, _newX7, _newY7, _newX6, _newY6);
            lastPoint = new Point(_newX6, _newY6);
            lastControlPoint = new Point(_newX7, _newY7);
            break;
          }

        case 'T':
          {
            var _cp3 = lastPoint,
                _p5 = s.getEnd();

            var _newX8 = _p5.x(),
                _newY8 = _p5.y(),
                _newX9 = _cp3.x(),
                _newY9 = _cp3.y();

            if (lastControlPoint) {
              _newX9 += lastPoint.x() - lastControlPoint.x();
              _newY9 += lastPoint.y() - lastControlPoint.y();
            }

            if (s.getRelative()) {
              _newX8 += lastPoint.x();
              _newY8 += lastPoint.y();
            }

            newGeom.quadTo(true, _newX9, _newY9, _newX8, _newY8);
            lastPoint = new Point(_newX8, _newY8);
            lastControlPoint = new Point(_newX9, _newY9);
            break;
          }

        case 'H':
          {
            var _newX10 = s.getX(),
                _newY10 = lastPoint.y();

            if (s.getRelative()) {
              _newX10 += lastPoint.x();
            }

            newGeom.lineTo(true, _newX10, _newY10);
            lastPoint = new Point(_newX10, _newY10);
            break;
          }

        case 'V':
          {
            var _newX11 = lastPoint.x(),
                _newY11 = s.getY();

            if (s.getRelative()) {
              _newY11 += lastPoint.y();
            }

            newGeom.lineTo(true, _newX11, _newY11);
            lastPoint = new Point(_newX11, _newY11);
            break;
          }

        case 'A':
          {
            var _p6 = s.getEnd();

            var _newX12 = _p6.x(),
                _newY12 = _p6.y();

            if (s.getRelative()) {
              _newX12 += lastPoint.x();
              _newY12 += lastPoint.y();
            }

            newGeom.arcTo(true, s.getRadiusX(), s.getRadiusY(), s.getXAxisRotation(), s.getLargeArcFlag(), s.getSweepFlag(), _newX12, _newY12);
            lastPoint = new Point(_newX12, _newY12);
            break;
          }

        default:
          {
            throw new Error('Invalid geom');
          }
      }

      ;
    });
    return newGeom.encodeToString();
  }
});
