function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/shape/Line
 */
define(['baja!', 'nmodule/bajaui/rc/ux/shape/Shape', 'nmodule/bajaui/rc/ux/shape/shapeUtil', 'baja!gx:Pen,gx:LineGeom', 'bajaux/spandrel', 'Promise', 'nmodule/gx/rc/baja/Pen'], function (baja, Shape, shapeUtil, types, spandrel, Promise, Pen) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-shape-Line',
        geom: baja.$('gx:LineGeom', 'null')
      }
    };
  };
  /**
   * bajaux implementation of Line.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/shape/Line
   * @extends module:nmodule/bajaui/rc/ux/shape/Shape
   */


  return /*#__PURE__*/function (_Shape) {
    _inherits(Line, _Shape);

    var _super = _createSuper(Line);

    function Line(params) {
      _classCallCheck(this, Line);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }

    _createClass(Line, [{
      key: "renderContents",
      value: function renderContents() {
        var properties = this.properties(),
            geom = properties.getValue('geom');
        var elem,
            x1 = geom.x1(),
            x2 = geom.x2(),
            y1 = geom.y1(),
            y2 = geom.y2();
        elem = document.createElementNS('http://www.w3.org/2000/svg', 'line');
        var points = [{
          x: x1,
          y: y1
        }, {
          x: x2,
          y: y2
        }];
        var content = elem;
        var params;

        if (this.$isGradient()) {
          var _shapeUtil$getRotateI = shapeUtil.getRotateInfo({
            points: points
          }),
              rotatedPoints = _shapeUtil$getRotateI.rotatedPoints,
              group = _shapeUtil$getRotateI.group,
              transformParams = _shapeUtil$getRotateI.transformParams;

          if (rotatedPoints) {
            group.insertBefore(elem, group.firstChild);
            content = group;
            params = transformParams;
            points = rotatedPoints;
          }
        }

        this.$transformParams = params;
        elem.setAttribute('x1', points[0].x);
        elem.setAttribute('y1', points[0].y);
        elem.setAttribute('x2', points[1].x);
        elem.setAttribute('y2', points[1].y);

        if (this.$isCrisp()) {
          elem.classList.add('hxpx-crisp');
        }

        elem.classList.add('hxpx-mouseHandler');
        return content;
      }
    }, {
      key: "getShapeEl",
      value: function getShapeEl(element) {
        return element.querySelector('line');
      }
      /**
       * If this `Line` is flat and is using a simple pen, but not a gradient,
       * then use a `hxpx-crisp` for drawing the line which results in better display.
       * @private
       * @return {boolean}
       */

    }, {
      key: "$isCrisp",
      value: function $isCrisp() {
        var properties = this.properties(),
            geom = properties.getValue('geom'),
            pen = properties.getValue('pen'),
            brush = properties.getValue('stroke');
        var isGradient = brush && brush.isGradientBrush(),
            flat = isStraightLine(geom),
            simplePen = isSimplePen(pen);
        return flat && simplePen && !isGradient;
      }
      /**
       * Return true if the line has a gradient.
       * @private
       * @return {boolean}
       */

    }, {
      key: "$isGradient",
      value: function $isGradient() {
        var properties = this.properties(),
            brush = properties.getValue('stroke');
        return brush && brush.isGradientBrush();
      }
    }]);

    return Line;
  }(Shape);

  function isSimplePen(pen) {
    return pen && !pen.getDash().length && pen.getCap() !== Pen.CAP_ROUND;
  }

  function isStraightLine(geom) {
    return isHorizontalLine(geom) || isVerticalLine(geom);
  }

  function isHorizontalLine(geom) {
    return Math.abs(geom.y1() - geom.y2()) < 1;
  }

  function isVerticalLine(geom) {
    return Math.abs(geom.x1() - geom.x2()) < 1;
  }
});
