function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/WebWidget
 */
define(['baja!', 'log!nmodule.bajaui.rc.ux.WebWidget', 'bajaux/events', 'bajaux/spandrel', 'bajaux/util/CommandButtonGroup', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/bajaui/rc/baja/binding/LoadBinding', 'nmodule/bajaui/rc/mixin/PreferredSizeSupport', 'nmodule/bajaui/rc/model/UxModelSupport', 'nmodule/gx/rc/baja/Size', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/util/ICollectionSupport', 'css!nmodule/bajaui/rc/bajaui'], function (baja, log, events, spandrel, CommandButtonGroup, Promise, _, switchboard, LoadBinding, PreferredSizeSupport, UxModelSupport, Size, fe, ICollectionSupport) {
  'use strict';

  var logWarning = log.warning.bind(log);
  var logSevere = log.severe.bind(log);

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-WebWidget bajaux-container ux-fg ux-root',
        js: baja.Ord.DEFAULT,
        preferredSize: Size.make(640, 480)
      }
    };
  };
  /**
   * bajaux implementation of `WebWidget`.
   * @class
   * @alias module:nmodule/bajaui/rc/ux/WebWidget
   * @extends module:bajaux/Widget
   * @mixes module:nmodule/bajaui/rc/mixin/PreferredSizeSupport
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(WebWidget, _spandrel);

    var _super = _createSuper(WebWidget);

    function WebWidget(params) {
      var _this;

      _classCallCheck(this, WebWidget);

      _this = _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
      UxModelSupport(_assertThisInitialized(_this));
      PreferredSizeSupport(_assertThisInitialized(_this));
      switchboard(_assertThisInitialized(_this), {
        $resolveAndLoad: {
          allow: 'oneAtATime'
        }
      });
      return _this;
    }
    /**
     * @override
     * @returns {module:nmodule/bajaui/rc/mixin/PreferredSizeSupport~Size|undefined}
     */


    _createClass(WebWidget, [{
      key: "getPreferredSize",
      value: function getPreferredSize() {
        var size = this.properties().getValue('preferredSize');

        if (!size || size === Size.NULL) {
          return;
        }

        var width = size.getWidth();
        var height = size.getHeight();
        return {
          width: width,
          height: height,
          minWidth: width,
          minHeight: height,
          maxWidth: width,
          maxHeight: height
        };
      }
    }, {
      key: "doSave",
      value: function doSave() {
        var contentWidget = this.$getContentWidget();
        return contentWidget.save();
      }
      /**
       * Apply the configured `preferredSize` property if the WebWidget is
       * statically sized.
       */

    }, {
      key: "doLayout",
      value: function doLayout() {
        this.applySize(this.jq()[0]);
      }
      /**
       * @returns {boolean} true iff the content widget is modified
       */

    }, {
      key: "isModified",
      value: function isModified() {
        var contentWidget = this.$getContentWidget();
        return !!(contentWidget && contentWidget.isModified());
      }
      /**
       * @private
       * @returns {Promise.<string>} the type of the web widget to load
       */

    }, {
      key: "$getWebWidgetType",
      value: function $getWebWidgetType() {
        var js = this.properties().getValue('js');
        var queryList = js.parse();
        var viewQuery = queryList.get('view');

        if (viewQuery) {
          return Promise.resolve(viewQuery.getBody());
        }

        var fileQuery = queryList.get('file');

        if (fileQuery) {
          return js.get().then(function (file) {
            return file.getReadUri();
          });
        }

        return Promise.reject(new Error('invalid js ord: ' + js));
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getContentWidget",
      value: function $getContentWidget() {
        return this.queryWidget('container/content');
      }
      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */

    }, {
      key: "$getToolbar",
      value: function $getToolbar() {
        return this.queryWidget('toolbar');
      }
      /**
       * Return true if the `contentWidget` has `ICollectionSupport` turned on.
       * @see module:nmodule/webEditors/rc/wb/util/ICollectionSupport#isOn
       * @private
       * @return {boolean}
       */

    }, {
      key: "$hasICollectionSupport",
      value: function $hasICollectionSupport() {
        var contentWidget = this.$getContentWidget();
        return contentWidget && ICollectionSupport.isOn(contentWidget);
      }
      /**
       * This will complete a resolve and load after the primary load has completed.
       * @private
       *
       * @param {module:baja/ord/OrdTarget} ordTarget
       * @returns {Promise}
       */

    }, {
      key: "$extraLoad",
      value: function $extraLoad(ordTarget) {
        var _this2 = this;

        // eslint-disable-next-line promise/avoid-new
        return new Promise(function (resolve, reject) {
          var contentWidget = _this2.$getContentWidget();

          var jq = _this2.jq();

          if (!contentWidget || contentWidget.value() === null) {
            jq.one(events.LOAD_EVENT, ".-t-WebWidget-inner", function () {
              resolve(_this2.$resolveAndLoad(ordTarget));
            });
            jq.one(events.LOAD_FAIL_EVENT, ".-t-WebWidget-inner", function (error) {
              reject(error);
            });
          } else {
            resolve(_this2.$resolveAndLoad(ordTarget));
          }
        });
      }
      /**
       * This will resolve and load the content widget when no other calls to `$resolveAndLoad` are happening.
       * @private
       *
       * @param {module:baja/ord/OrdTarget} ordTarget
       * @returns {Promise}
       */

    }, {
      key: "$resolveAndLoad",
      value: function $resolveAndLoad(ordTarget) {
        var contentWidget = this.$getContentWidget(); //inner widget is in the process of reloading, so wait for it

        if (!contentWidget) {
          this.$extraLoad(ordTarget)["catch"](logSevere);
          return Promise.resolve();
        }

        var resolveParams = {
          existingOrdTarget: ordTarget
        };
        return contentWidget.resolve(ordTarget.getOrd(), resolveParams).then(function (value) {
          return contentWidget.load(value);
        });
      }
    }]);

    return WebWidget;
  }(spandrel(function (model, _ref) {
    var _this3 = this;

    var properties = _ref.properties,
        rootElement = _ref.rootElement;
    var value = model.getValue();
    var bindingList = model.getBindingList();
    var widgetDom = document.createElement('div');
    widgetDom.classList.add('-t-WebWidget-inner');
    widgetDom.classList.add('bajaux-widget');
    var containerDom = document.createElement('div');
    containerDom.classList.add('bajaux-widget-container');
    containerDom.classList.add('ux-fullscreen-support');
    this.applySize(containerDom, rootElement);
    var contentProps = stringEncodeProperties(properties);
    Object.assign(contentProps, {
      $keepClassNames: true,
      $quiet: false
    });
    delete contentProps.js;
    delete contentProps.preferredSize;
    return this.$getWebWidgetType().then(function (widgetType) {
      return {
        toolbar: {
          dom: '<div class="bajaux-toolbar-outer"/>',
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          }
        },
        container: {
          dom: containerDom,
          kids: {
            content: {
              dom: widgetDom,
              formFactors: ['max', 'compact', 'mini'],
              type: widgetType,
              properties: contentProps,
              value: value,
              hooks: {
                preLoad: function preLoad(widget, buildContext) {
                  return resolveBindings(widget, bindingList, buildContext);
                },
                postLoad: function postLoad(widget) {
                  if (widget.properties().getValue('hideCommandBar')) {
                    return;
                  }

                  return _this3.$getToolbar().load(widget.getCommandGroup());
                }
              },
              //prevent key events if the widget is disabled.
              //mouse events prevented via pointer-events: none.
              on: ['keydown', function () {
                return _this3.isEnabled();
              }]
            }
          }
        }
      };
    });
  }, {
    manager: fe.getWidgetManager()
  }));
  /**
   * Resolve all non-secondary Bindings against the Widget and ensure the Widget's
   * desired value is loaded.
   *
   * @param {module:bajaux/Widget} widget
   * @param {module:nmodule/bajaui/rc/model/BindingList} bindingList
   * @param {module:bajaux/lifecycle/WidgetManager~BuildContext} buildContext
   * @return {Promise}
   */

  function resolveBindings(widget, bindingList, buildContext) {
    return bindingList.map(function (binding) {
      if (!(binding instanceof LoadBinding)) {
        return;
      }

      if (_.isFunction(binding.$isPrimaryBinding)) {
        if (!binding.$isPrimaryBinding()) {
          return;
        }
      }

      var ordTarget = binding.getOrdTarget();

      if (!ordTarget) {
        return;
      }

      return Promise["try"](function () {
        return widget.resolve(ordTarget.getOrd(), {
          existingOrdTarget: ordTarget
        }).then(function (value) {
          //If the widget changes the value to load (Like a WebHistoryTable on a HistoryExt),
          //this modification ensures that the widget's desired value is loaded.
          buildContext.value = value;
        });
      })["catch"](logWarning);
    });
  }
  /**
   * To match current behavior, any properties that are BajaScript values
   * (other than string/number/boolean) will be string-encoded.
   *
   * @param {object} properties
   * @returns {object}
   * @see javax.baja.ui.util.WebProperty#encodeValue(BValue)
   */


  function stringEncodeProperties(properties) {
    return _.mapObject(properties, function (value) {
      if (!baja.hasType(value, 'baja:Simple')) {
        return value;
      }

      var type = value.getType();

      if (type.is('baja:Number')) {
        return +value;
      }

      if (type.is('baja:Boolean')) {
        return value;
      }

      if (type.is('baja:Enum')) {
        return value.getTag();
      }

      return value.encodeToString();
    });
  }
});
