function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/* global document */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/TabbedPane
 */
define(['baja!', 'baja!bajaui:Align,bajaui:DegradeBehavior,bajaui:Halign,bajaui:Valign', 'bajaux/spandrel', 'bajaux/Widget', 'jquery', 'underscore', 'nmodule/bajaui/rc/baja/Border', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/binding/impl/widgetEvents', 'nmodule/bajaui/rc/model/BindingList', 'nmodule/bajaui/rc/model/UxModel', 'nmodule/bajaui/rc/ux/BorderPane', 'nmodule/bajaui/rc/ux/EdgePane', 'nmodule/bajaui/rc/ux/FlowPane', 'nmodule/bajaui/rc/ux/TabbedPaneContent', 'nmodule/gx/rc/baja/Insets', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, spandrel, Widget, $, _, Border, Binding, widgetEvents, BindingList, UxModel, BorderPane, EdgePane, FlowPane, TabbedPaneContent, Insets) {
  'use strict';

  var DISABLED_TAB_CLASS = 'ux-TabbedPane-tab-disabled';
  var SELECTED_TAB_CLASS = 'ux-TabbedPane-tab-selected';
  var UNSELECTED_TAB_CLASS = 'ux-TabbedPane-tab-unselected';
  var SELECTED_CONTENT_CLASS = '-t-TabbedPane-content-selected';
  var UNSELECTED_CONTENT_CLASS = '-t-TabbedPane-content-unselected';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-TabbedPane',
        tabPlacement: baja.$('bajaui:Align', 'top'),
        showSingleTab: true,
        paintFullBorder: true
      }
    };
  };
  /**
   * bajaux implementation of `bajaui:TabbedPane`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/TabbedPane
   * @extends {module:bajaux/Widget}
   */


  var TabbedPane = /*#__PURE__*/function (_spandrel) {
    _inherits(TabbedPane, _spandrel);

    var _super = _createSuper(TabbedPane);

    function TabbedPane(params) {
      var _this;

      _classCallCheck(this, TabbedPane);

      _this = _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
      _this.$selectedIndex = 0;
      return _this;
    }
    /**
     *
     * @private
     * @param {module:nmodule/bajaui/rc/model/UxModel} model
     * @param {Object} tabbedPaneProperties properties of the Tabbed Editor
     * @return {Array.<Object>}
     */


    _createClass(TabbedPane, [{
      key: "$getKids",
      value: function $getKids(model, tabbedPaneProperties) {
        var tabPlacement = tabbedPaneProperties.tabPlacement,
            showSingleTab = tabbedPaneProperties.showSingleTab;
        var labelKids = this.$getLabelKids(model, tabPlacement);

        if (labelKids.length === 0) {
          return [];
        } //To match workbench, force no border when showSingleTab=false, paintFullBorder=true, and there is a single Tab.


        if (labelKids.length === 1 && !showSingleTab) {
          tabbedPaneProperties.paintFullBorder = false;
        }

        var contentWrapper = this.$getContentWrapper(model, tabbedPaneProperties);

        if (labelKids.length === 1 && !showSingleTab) {
          return [contentWrapper];
        }

        return [{
          name: getTabPlacementName(tabPlacement),
          type: FlowPane,
          kids: labelKids,
          properties: {
            rootCssClass: 'ux-TabbedPane-tabs ux-FlowPane',
            hgap: 0,
            vgap: 0,
            align: baja.$('bajaui:Halign', 'fill'),
            rowAlign: baja.$('bajaui:Valign', 'fill')
          }
        }, contentWrapper];
      }
      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/UxModel} model
       * @param {baja.FrozenEnum} tabPlacement
       * @return {Array.<Object>}
       */

    }, {
      key: "$getLabelKids",
      value: function $getLabelKids(model, tabPlacement) {
        var _this2 = this;

        var filteredKids = getFilteredKids(model);
        return _.map(filteredKids, function (kid, index) {
          var disabled = kid.getProperties().enabled === false;
          var showLabelPane = kid.getProperties().visible !== false;
          var model = kid.get('label');
          return _this2.$getLabelWrapper(model, index, disabled, showLabelPane, tabPlacement);
        });
      }
      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/UxModel} model
       * @return {Array.<Object>}
       */

    }, {
      key: "$getContentKids",
      value: function $getContentKids(model) {
        var _this3 = this;

        var filteredKids = getFilteredKids(model);
        return _.map(filteredKids, function (kid, index) {
          var model = kid.get('content');

          var contentModel = _this3.$getMainContentWrapper(model, index);

          contentModel.properties.visible = true;
          return contentModel;
        });
      }
      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/UxModel} model
       * @return {Object}
       */

    }, {
      key: "$getModelObject",
      value: function $getModelObject(model, forceVisible) {
        var properties = model.getProperties();

        if (forceVisible) {
          properties.visible = true;
        }

        return {
          bindings: model.getBindingList().getBindings(),
          name: 'content',
          type: model.getType(),
          properties: properties,
          kids: model.getKids()
        };
      }
      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/UxModel} model
       * @param {Number} index
       * @return {Object}
       */

    }, {
      key: "$getMainContentWrapper",
      value: function $getMainContentWrapper(model, index) {
        var selectedClass = this.getSelectedIndex() === index ? SELECTED_CONTENT_CLASS : UNSELECTED_CONTENT_CLASS;
        var properties = {
          margin: Insets.make(0),
          padding: Insets.make(0),
          rootCssClass: 'ux-BorderPane ux-TabbedPane-content ' + selectedClass
        };
        return {
          properties: properties,
          name: 'content',
          type: BorderPane,
          kids: [this.$getModelObject(model, true)]
        };
      }
      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/UxModel} model
       * @param {Number} index
       * @param {boolean} disabledLabelPane
       * @param {boolean} showLabelPane
       * @param {baja.FrozenEnum} tabPlacement
       * @return {Object}
       */

    }, {
      key: "$getLabelWrapper",
      value: function $getLabelWrapper(model, index, disabledLabelPane, showLabelPane, tabPlacement) {
        var disabledClass = disabledLabelPane ? DISABLED_TAB_CLASS : '';
        var selectedClass = this.getSelectedIndex() === index ? SELECTED_TAB_CLASS : UNSELECTED_TAB_CLASS;
        var placementTag = tabPlacement.getTag();

        if (placementTag === 'center') {
          placementTag = 'top';
        }

        var properties = {
          margin: Insets.make(0),
          padding: Insets.make(0),
          rootCssClass: ['ux-BorderPane', 'ux-TabbedPane-tab', 'ux-TabbedPane-tab-' + placementTag, selectedClass, disabledClass].join(' '),
          visible: showLabelPane
        };
        return {
          properties: properties,
          name: model.getName(),
          type: BorderPane,
          bindings: [new TabSelectedBinding(index)],
          kids: [this.$getModelObject(model)]
        };
      }
      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/UxModel} model
       * @param {Object} tabbedPaneProperties properties of the Tabbed Editor
       * @return {Object}
       */

    }, {
      key: "$getContentWrapper",
      value: function $getContentWrapper(model, tabbedPaneProperties) {
        var paintFullBorder = tabbedPaneProperties.paintFullBorder;
        var properties = {
          border: Border.NULL,
          margin: Insets.make(0),
          padding: Insets.make(0),
          rootCssClass: 'ux-BorderPane ux-TabbedPane-content' + (paintFullBorder ? ' ux-TabbedPane-content-paintFullBorder' : '')
        };
        return {
          name: 'center',
          properties: properties,
          type: BorderPane,
          kids: [this.$getContent(model)]
        };
      }
      /**
       * @private
       * @param {module:nmodule/bajaui/rc/model/UxModel} model
       * @return {Object}
       */

    }, {
      key: "$getContent",
      value: function $getContent(model) {
        return {
          name: 'content',
          type: TabbedPaneContent,
          kids: this.$getContentKids(model)
        };
      }
      /**
       * @return {Number}
       */

    }, {
      key: "getSelectedIndex",
      value: function getSelectedIndex() {
        return this.$selectedIndex;
      }
    }]);

    return TabbedPane;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
        rootElement = _ref.rootElement;
    var div = document.createElement('div'),
        selectedIndex = this.$selectedIndex;
    div.classList.add('-t-TabbedPane-content');
    rootElement.classList.add("ux-TabbedPane");
    var filteredKids = getFilteredKids(model);
    var selectedKid = filteredKids[selectedIndex];

    if (selectedKid) {
      var disabled = selectedKid.getProperties().enabled === false;
      var hidden = selectedKid.getProperties().visible === false;

      if (disabled || hidden) {
        var bestSelectedIndex = getBestSelectedIndex(selectedIndex, filteredKids);

        if (bestSelectedIndex === -1) {
          return document.createElement('wbr');
        }

        if (bestSelectedIndex !== selectedIndex) {
          this.$selectedIndex = bestSelectedIndex;
        }
      }
    }

    var kids = this.$getKids(model, properties);
    var modelParams = {
      name: model.getName(),
      type: EdgePane,
      kids: kids
    };
    return UxModel.make(modelParams).then(function (model) {
      return [model.toSpandrel(div)];
    });
  }));
  /**
   * @private
   * @inner
   * @param {baja.FrozenEnum} tabPlacement
   * @returns {string} EdgePane cell name for location of Labels
   */


  function getTabPlacementName(tabPlacement) {
    return tabPlacement.getTag() === 'center' ? 'top' : tabPlacement.getTag();
  }
  /**
   * @private
   * @class
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   * @memberOf module:nmodule/bajaui/rc/ux/TabbedPane
   * @param {Number} index
   */


  var TabSelectedBinding = /*#__PURE__*/function (_Binding) {
    _inherits(TabSelectedBinding, _Binding);

    var _super2 = _createSuper(TabSelectedBinding);

    function TabSelectedBinding(index) {
      var _this4;

      _classCallCheck(this, TabSelectedBinding);

      _this4 = _super2.call(this);
      _this4.$index = index; //Workaround for https://acsjira.honeywell.com/browse/NCCB-47402

      _this4.add({
        slot: 'ord',
        value: baja.Ord.DEFAULT
      });

      _this4.add({
        slot: 'degradeBehavior',
        value: baja.$('bajaui:DegradeBehavior')
      });

      return _this4;
    }
    /**
     *
     * Add event listeners for the widget:
     * - on click, change the tab, even if there is a ValueBinding which would normally consume the click behavior.
     * This is why the addEventListener with useCapture=true is used.
     *
     * @param {module:bajaux/Widget} widget
     */


    _createClass(TabSelectedBinding, [{
      key: "addListeners",
      value: function addListeners(widget) {
        var _this5 = this;

        if (widget.isInitialized()) {
          this.$arm(widget);
        } else {
          widget.on('initialized', function () {
            _this5.$arm(widget);
          });
        }
      }
      /**
       * @private
       * @param {module:bajaux/Widget} widget
       */

    }, {
      key: "$arm",
      value: function $arm(widget) {
        var _this6 = this;

        this.$eventListener = function (event) {
          var targetDom = $(event.currentTarget);

          if (targetDom.hasClass(DISABLED_TAB_CLASS) || targetDom.hasClass(SELECTED_TAB_CLASS)) {
            return;
          } //change labels


          var flow = targetDom.closest(".-t-FlowPane-contents");
          var index = _this6.$index;

          _toConsumableArray(flow.children()).forEach(function (elem, i) {
            var classList = elem.firstChild.classList;
            var selected = index === i;
            classList.toggle(SELECTED_TAB_CLASS, selected);
            classList.toggle(UNSELECTED_TAB_CLASS, !selected);
          }); //change content


          var selectedElem = null;
          var contentChildren = targetDom.closest(".-t-TabbedPane-content").find(".-t-TabbedPane-content-child-content");

          _toConsumableArray(contentChildren).forEach(function (elem, i) {
            var classList = elem.classList;
            var selected = index === i;
            classList.toggle(SELECTED_CONTENT_CLASS, selected);
            classList.toggle(UNSELECTED_CONTENT_CLASS, !selected);

            if (selected) {
              selectedElem = elem;
            }
          });

          var tabbedPane = getTabbedPane(flow);
          tabbedPane.$selectedIndex = _this6.$index;
          var widget = Widget["in"](selectedElem);

          if (widget) {
            //The visibility changes the widget's size so layout needs to be called on newly Visible widget once the
            //other content widgets is  hidden too and full space is available
            widget.layout()["catch"](baja.error);
          }
        };

        getDom(widget).addEventListener('mousedown', this.$eventListener, true);
        widget.on('destroyed', function () {
          getDom(widget).removeEventListener('mousedown', _this6.$eventListener, true);
        });
      }
    }]);

    return TabSelectedBinding;
  }(Binding);
  /**
   * @private
   * @inner
   * @param {JQuery} jq An element that is inside a TabbedPane
   * @return {module:nmodule/bajaui/rc/ux/TabbedPane}
   */


  function getTabbedPane(jq) {
    return Widget["in"](jq.closest(".ux-TabbedPane"));
  }
  /**
   *
   * @private
   * @inner
   * @param {module:bajaux/Widget} widget
   * @return {HTMLElement}
   */


  function getDom(widget) {
    return widget.jq()[0];
  }
  /**
   * Filters out the kid named 'tabControl' if it is present.
   * @private
   * @inner
   * @param {module:nmodule/bajaui/rc/model/UxModel} model
   * @return {Array.<module:nmodule/bajaui/rc/model/UxModel>}
   */


  function getFilteredKids(model) {
    return _.filter(model.getKids(), function (kid) {
      return kid.getName() !== 'tabControl';
    });
  }
  /**
   * Return the first enabled  and visible tab, or if no tabs are enabled, return the current selection as a fallback.
   * @private
   * @inner
    * @param {Number} selectedIndex
   * @param {Array.<module:nmodule/bajaui/rc/model/UxModel>} kids
   * @return {number}
   */


  function getBestSelectedIndex(selectedIndex, kids) {
    var visibleIndex = -1;

    for (var i = 0; i < kids.length; i++) {
      var _kids$i$getProperties = kids[i].getProperties(),
          enabled = _kids$i$getProperties.enabled,
          visible = _kids$i$getProperties.visible;

      if (enabled !== false && visible !== false) {
        return i;
      }

      if (visible !== false) {
        visibleIndex = i;
      }
    }

    if (visibleIndex !== -1) {
      return selectedIndex;
    } else {
      return visibleIndex;
    }
  }

  return TabbedPane;
});
