function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/SplitPane
 */
define(['baja!', 'baja!bajaui:Orientation,bajaui:NullWidget', 'bajaux/spandrel', 'nmodule/js/rc/jquery/split-pane/split-pane', 'css!nmodule/bajaui/rc/bajaui', 'css!nmodule/js/rc/jquery/split-pane/split-pane'], function (baja, types, spandrel) {
  'use strict';

  var NULL_WIDGET = baja.$("bajaui:NullWidget");

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-SplitPane',
        widget1: NULL_WIDGET,
        widget2: NULL_WIDGET,
        dividerWidth: 6,
        moveableDivider: true,
        dividerPosition: 50,
        orientation: baja.$("bajaui:Orientation", "horizontal"),
        continuousLayout: true
      }
    };
  };

  var getDividerStyle = function getDividerStyle(isHorizontal, dividerPosition, dividerWidth) {
    var dividerWidthStyle = "".concat(dividerWidth, "px"),
        dividerStyle = {};

    if (isHorizontal) {
      dividerStyle.width = dividerWidthStyle;
    } else {
      dividerStyle.height = dividerWidthStyle;
    }

    return dividerStyle;
  };
  /**
   * Gets the current position of the divider from the DOM and does a calculation
   * to translate it to the opposite orientation.
   *
   * @inner
   * @param {boolean} fromHorizontalToVertical determines which way to translate
   * @param {number} dividerWidth width of divider in pixels
   * @param {JQuery} splitPaneJq
   * @param {JQuery} splitPaneDividerJq
   * @returns {number} divider position in pixels
   */


  var translateDividerPosition = function translateDividerPosition(fromHorizontalToVertical, dividerWidth, splitPaneJq, splitPaneDividerJq) {
    var halfWidth = dividerWidth / 2;

    if (fromHorizontalToVertical) {
      var _dividerPosition = parseFloat(splitPaneDividerJq.css("left")) + halfWidth;

      return _dividerPosition / splitPaneJq.width() * splitPaneJq.height() - halfWidth;
    }

    var dividerPosition = parseFloat(splitPaneDividerJq.css("top")) + halfWidth;
    return dividerPosition / splitPaneJq.height() * splitPaneJq.width() - halfWidth;
  };
  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/SplitPane
   * @extends module:bajaux/Widget
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(SplitPane, _spandrel);

    var _super = _createSuper(SplitPane);

    function SplitPane(params) {
      _classCallCheck(this, SplitPane);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }

    _createClass(SplitPane, [{
      key: "doLayout",
      value: function doLayout() {
        if (!this.$isSplitPaneInstalled) {
          this.$installSplitPane();
        }
      }
    }, {
      key: "doChanged",
      value: function doChanged(name, value) {
        var _this = this;

        var currentDividerPosition;
        var properties = this.properties(),
            isHorizontal = properties.getValue("orientation").getTag() === "horizontal",
            splitPaneJq = this.$getSplitPaneJq(),
            dividerWidth = properties.getValue("dividerWidth"),
            splitPaneDividerJq = splitPaneJq.find(".-t-SplitPane-divider").first();

        if (name === "orientation") {
          currentDividerPosition = translateDividerPosition(!isHorizontal, dividerWidth, splitPaneJq, splitPaneDividerJq);
        } else {
          currentDividerPosition = isHorizontal ? parseFloat(splitPaneDividerJq.css("left")) : parseFloat(splitPaneDividerJq.css("top"));
        }

        return _get(_getPrototypeOf(SplitPane.prototype), "doChanged", this).call(this, name, value).then(function () {
          if (name === "dividerPosition") {
            _this.$setupSplitPaneComponents();
          } else {
            _this.$setFirstComponentSize(currentDividerPosition);
          }
        });
      }
    }, {
      key: "$setupSplitPaneComponents",
      value: function $setupSplitPaneComponents() {
        var properties = this.properties(),
            splitPaneJq = this.$getSplitPaneJq(),
            isHorizontal = properties.getValue("orientation").getTag() === "horizontal",
            size = isHorizontal ? splitPaneJq.width() : splitPaneJq.height(),
            dividerPosition = properties.getValue("dividerPosition"),
            dividerWidth = properties.getValue("dividerWidth"),
            dividerPositionPixels = size * dividerPosition / 100 - dividerWidth / 2,
            firstComponentSize = dividerPositionPixels,
            secondComponentSize = size - firstComponentSize - dividerWidth;

        if (isHorizontal) {
          splitPaneJq.children(".split-pane-component:first").css("right", size - firstComponentSize + "px");
          splitPaneJq.children(".split-pane-divider:first").css("right", secondComponentSize + "px");
          splitPaneJq.children(".split-pane-component:last").css("width", secondComponentSize + "px");
        } else {
          splitPaneJq.children(".split-pane-component:first").css("bottom", size - firstComponentSize + "px");
          splitPaneJq.children(".split-pane-divider:first").css("bottom", secondComponentSize + "px");
          splitPaneJq.children(".split-pane-component:last").css("height", secondComponentSize + "px");
        }
      }
    }, {
      key: "$setFirstComponentSize",
      value: function $setFirstComponentSize(size) {
        this.$getSplitPaneJq().splitPane('firstComponentSize', size);
      }
    }, {
      key: "$getSplitPaneJq",
      value: function $getSplitPaneJq() {
        return this.jq().children(".-t-SplitPane-inner");
      }
    }, {
      key: "$installSplitPane",
      value: function $installSplitPane() {
        this.$setupSplitPaneComponents();
        this.$getSplitPaneJq().splitPane();
        this.$isSplitPaneInstalled = true;
      }
    }]);

    return SplitPane;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var orientation = properties.orientation,
        dividerPosition = properties.dividerPosition,
        dividerWidth = properties.dividerWidth,
        moveableDivider = properties.moveableDivider,
        isHorizontal = orientation.getTag() === "horizontal",
        orientationClass = isHorizontal ? "vertical-percent" : "horizontal-percent",
        splitPaneClasses = "-t-SplitPane-inner split-pane ".concat(orientationClass),
        dividerStyle = getDividerStyle(isHorizontal, dividerPosition, dividerWidth),
        widget1 = model.get('widget1'),
        widget2 = model.get('widget2'),
        moveableDividerClass = moveableDivider ? "" : "-t-SplitPane-divider-not-moveable";
    return spandrel.jsx("div", {
      className: splitPaneClasses
    }, spandrel.jsx("div", {
      className: "split-pane-component"
    }, widget1 && widget1.toSpandrel('<div class="-t-SplitPane-kid"></div>')), spandrel.jsx("div", {
      className: "split-pane-divider -t-SplitPane-divider ".concat(moveableDividerClass),
      style: dividerStyle
    }), spandrel.jsx("div", {
      className: "split-pane-component"
    }, widget2 && widget2.toSpandrel('<div class="-t-SplitPane-kid"></div>')));
  }));
});
