function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/** @jsx spandrel.jsx */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/Slider
 */
define(['baja!', 'bajaux/spandrel', 'nmodule/bajaui/rc/binding/impl/widgetEvents', 'nmodule/bajaui/rc/ux/bajauiEvents', 'nmodule/bajaui/rc/ux/ToolTip', 'baja!bajaui:Orientation,gx:Brush'], function (baja, spandrel, widgetEvents, bajauiEvents, ToolTip, types) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Slider',
        enabled: true,
        increment: 1,
        max: 100,
        min: 0,
        orientation: baja.$('bajaui:Orientation', 'horizontal'),
        thumbBrush: baja.$('gx:Brush', 'null'),
        trackBrush: baja.$('gx:Brush', 'null'),
        value: 50,
        visible: true
      }
    };
  };
  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/Slider
   * @extends {module:bajaux/Widget}
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(Slider, _spandrel);

    var _super = _createSuper(Slider);

    function Slider(params) {
      var _this;

      _classCallCheck(this, Slider);

      _this = _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
      _this.$inputId = _this.generateId();
      _this.$wrapperId = _this.generateId();
      return _this;
    }

    _createClass(Slider, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        var setDisplay;
        widgetEvents(this, {
          change: function change(e) {
            _this2.properties().setValue('value', parseFloat(_this2.$getSlider().jq().val(), 10));

            _this2.emit(bajauiEvents.ACTION_PERFORMED_EVENT, e && e.type);

            return Promise.resolve();
          },
          mousedown: function mousedown(e) {
            var onCancel = function onCancel(reason) {
              if (reason === "multitouch") {
                _this2.$setInputDisabled(true);

                _this2.$setInputValue(_this2.properties().getValue('value'));
              }
            };

            var obj = ToolTip.create(e, _this2.properties().getValue('value'), {
              onCancel: onCancel
            });
            setDisplay = obj && obj.setDisplay;
          },
          input: function input() {
            var value = _this2.$getSlider().jq().val();

            setDisplay && setDisplay(value);
          },
          mouseup: function mouseup() {
            var enabled = _this2.properties().getValue('enabled');

            if (enabled) {
              _this2.$setInputDisabled(false);
            }
          }
        });
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.$applyStyles();
      }
      /**
       * 
       * @private
       */

    }, {
      key: "$getSlider",
      value: function $getSlider() {
        return this.queryWidget('wrapper/slider');
      }
      /**
       * @private
       * @param {boolean} disabled
       */

    }, {
      key: "$setInputDisabled",
      value: function $setInputDisabled(disabled) {
        this.$getSlider().jq().prop('disabled', disabled);
      }
      /**
       * @private
       */

    }, {
      key: "$setInputValue",
      value: function $setInputValue(value) {
        this.$getSlider().jq().val(value);
      }
      /**
       * HTML input of type range can be styled only via pseudo-elements.
       * To dynamically style the slider track and thumb, we add an inline 
       * style to each slider.
       * WebKit-based browsers and Firefox are supported.
       * 
       * @private
       */

    }, {
      key: "$applyStyles",
      value: function $applyStyles() {
        var slider = this.$getSlider(),
            sliderContainer = this.jq(),
            props = this.properties(),
            trackBrush = props.getValue('trackBrush'),
            thumbBrush = props.getValue('thumbBrush'),
            orientation = props.getValue('orientation'),
            isSliderVertical = isVertical(orientation.getTag()),
            layout = props.getValue('layout'),
            height = sliderContainer && sliderContainer.innerHeight(),
            width = sliderContainer && sliderContainer.innerWidth(),
            inputId = this.$inputId,
            wrapperId = this.$wrapperId;

        if (slider && layout && sliderContainer) {
          var thumbStyle = getThumbStyle(width, height, thumbBrush, isSliderVertical);
          var trackStyle = getTrackStyle(width, height, trackBrush, isSliderVertical);
          var style = document.createElement('style');
          style.innerHTML = "\n          #".concat(wrapperId, " {\n            width: ").concat(width, "px;\n            height: ").concat(height, "px;\n          }\n          #").concat(inputId, " {\n            ").concat(isSliderVertical ? "width: ".concat(height, "px;\n            height: ").concat(width, "px;\n            transform-origin: left top;\n            transform: rotate(-90deg) translate(").concat(-1 * height, "px, 0);") : "\n            width: ".concat(width, "px;\n            height: ").concat(height, "px;"), "\n          }\n          #").concat(inputId, "::-webkit-slider-thumb {\n            ").concat(thumbStyle, "\n            transform: translate(0, ").concat(-1 * (getTrackWidth() + 1
          /** 1px added to fix overflow */
          ), "px);\n          }\n          #").concat(inputId, "::-webkit-slider-runnable-track {\n            ").concat(trackStyle, "\n          }\n          #").concat(inputId, "::-moz-range-thumb {\n            ").concat(thumbStyle, "\n            transform: translate(0, 0);\n          }\n          #").concat(inputId, "::-moz-range-track {\n            ").concat(trackStyle, "\n          }\n        ");
          var inputStyle = sliderContainer.find('style');

          if (inputStyle.length > 0) {
            sliderContainer[0].removeChild(inputStyle[0]);
          }

          sliderContainer[0].appendChild(style);
        }
      }
    }]);

    return Slider;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
        rootElement = _ref.rootElement;
    var enabled = properties.enabled,
        increment = properties.increment,
        max = properties.max,
        min = properties.min,
        value = properties.value,
        orientation = properties.orientation;
    var classList = rootElement.classList;
    classList.add('-t-Slider-orientation-' + orientation.getTag());
    return spandrel.jsx("div", {
      "class": "-t-slider-wrapper",
      spandrelKey: "wrapper",
      id: this.$wrapperId
    }, spandrel.jsx("input", {
      type: "range",
      id: this.$inputId,
      disabled: !enabled,
      min: min,
      max: max,
      step: increment,
      value: value,
      spandrelKey: "slider"
    }));
  }));

  function isVertical(orientationTag) {
    return orientationTag === 'vertical';
  }

  function getTrackStyle(width, height, trackBrush, isSliderVertical) {
    var containerWidth = isSliderVertical ? width : height,
        trackWidth = getTrackWidth(),
        // Calculates the position of the track inside the containing div
    trackOffset = (containerWidth - trackWidth) / 2 - trackWidth;
    return "".concat(!trackBrush.isNull() ? "background: ".concat(trackBrush.toString(), ";") : "", "\n      transform: translate(0, ").concat(-1 * Math.floor(trackOffset), "px);");
  }

  function getThumbStyle(width, height, thumbBrush, isSliderVertical) {
    // reduce the height by 1px to adjust for thumb overflow wrt the containing div
    return "".concat(isSliderVertical ? "height: ".concat(width - 1, "px;\n       cursor: ns-resize;") : "height: ".concat(height - 1, "px;\n       cursor: ew-resize;"), "\n      width: 12px;\n      ").concat(!thumbBrush.isNull() ? "background: ".concat(thumbBrush.toString(), ";") : "");
  }

  function getTrackWidth() {
    return 5;
  }
});
