function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/ScrollPane
 */
define(['baja!', 'baja!bajaui:ScrollBarPolicy,gx:Brush', 'bajaux/spandrel', 'underscore'], function (baja, types, spandrel, _) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-ScrollPane',
        hpolicy: baja.$('bajaui:ScrollBarPolicy', 'asNeeded'),
        vpolicy: baja.$('bajaui:ScrollBarPolicy', 'asNeeded'),
        viewportBackground: baja.$('gx:Brush', 'null'),
        borderPolicy: baja.$('bajaui:ScrollBarPolicy', 'always')
      }
    };
  };
  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/ScrollPane
   * @extends {module:bajaux/Widget}
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(ScrollPane, _spandrel);

    var _super = _createSuper(ScrollPane);

    function ScrollPane(params) {
      _classCallCheck(this, ScrollPane);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }
    /**
     * Store the scrollTop/scrollLeft so they can be restored after any child
     * widgets may cause it to scroll around during layout.
     */


    _createClass(ScrollPane, [{
      key: "layoutStarted",
      value: function layoutStarted() {
        var jq = this.jq();
        var el = jq && jq[0];

        if (el) {
          this.$scrollTop = el.scrollTop;
          this.$scrollLeft = el.scrollLeft;
        }
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var viewportBackground = this.properties().getValue('viewportBackground');

        if (this.jq() && viewportBackground) {
          viewportBackground.applyBackgroundToElement(this.jq()[0]);
        }
      }
      /**
       * Restore scrollTop/scrollLeft stored in layoutStarted.
       */

    }, {
      key: "layoutFinished",
      value: function layoutFinished() {
        var jq = this.jq();
        var el = jq && jq[0];

        if (el) {
          el.scrollTop = this.$scrollTop;
          el.scrollLeft = this.scrollLeft;
        }
      }
    }]);

    return ScrollPane;
  }(spandrel(function (dataModel, _ref) {
    var properties = _ref.properties,
        rootElement = _ref.rootElement;
    var hpolicy = properties.hpolicy,
        vpolicy = properties.vpolicy,
        viewportBackground = properties.viewportBackground,
        borderPolicy = properties.borderPolicy;
    var style = rootElement.style;
    style.overflowX = toOverflow(hpolicy);
    style.overflowY = toOverflow(vpolicy);
    viewportBackground.applyBackgroundToElement(rootElement);

    if (isBorderShown(borderPolicy, hpolicy, vpolicy)) {
      rootElement.classList.add('ux-ScrollPane-with-border');
    }

    var kid = dataModel.get('content');

    if (!kid) {
      return '<wbr/>';
    }

    return [{
      dom: '<div class="-t-ScrollPane-wrapper"></div>',
      kids: [kid.toSpandrel('<div class="-t-ScrollPane-content"></div>')]
    }];
  }));

  function isBorderShown(borderPolicy, hpolicy, vpolicy) {
    var borderPolicyTag = borderPolicy.getTag();

    if (!borderPolicyTag) {
      return false;
    } else if (borderPolicyTag === "always") {
      return true;
    } else if (borderPolicyTag === "asNeeded") {
      var hpolicyTag = hpolicy.getTag(),
          vpolicyTag = vpolicy.getTag();
      return hpolicyTag === "always" || vpolicyTag === "always";
    }

    return false;
  }

  function toOverflow(scrollBarPolicy) {
    switch (scrollBarPolicy.getTag()) {
      case 'asNeeded':
        return 'auto';

      case 'always':
        return 'scroll';

      case 'never':
        return 'hidden';

      default:
        return '';
    }
  }
});
