function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam and JJ Frankovich
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/Label
 */
define(['baja!', 'baja!bajaui:Align,bajaui:Halign,bajaui:Valign,gx:Size,gx:Image,gx:Brush,gx:Font,gx:Insets', 'bajaux/icon/iconUtils', 'bajaux/spandrel', 'nmodule/bajaui/rc/util/pxUtils', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, types, iconUtils, spandrel, pxUtils, IconEditor, htmlUtils) {
  'use strict';

  var escapeHtml = htmlUtils.escapeHtml;

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Label',
        enabled: true,
        visible: true,
        text: "",
        image: baja.$('gx:Image', 'null'),
        margin: baja.$('gx:Insets', 0),
        font: baja.$('gx:Font', 'null'),
        foreground: baja.$('gx:Brush', 'null'),
        background: baja.$('gx:Brush', 'null'),
        halign: baja.$('bajaui:Halign', 'center'),
        valign: baja.$('bajaui:Valign', 'center'),
        textToIconAlign: baja.$('bajaui:Align', 'right'),
        textIconGap: 4,
        blink: false,
        wordWrapEnabled: false
      }
    };
  }; //TODO: handle font facets with themes (NCCB-41325, NCCB-31016) as part of upcoming NCCB-45823

  /**
   * Label is a Widget for bajaui:Label.
   * Label supports an addition web property called `margin` of type `gx:Inset` that defaults to `0`.
   * A non-zero margin is added to the container element for the `text` and `image`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/Label
   * @extends {module:bajaux/Widget}
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(Label, _spandrel);

    var _super = _createSuper(Label);

    function Label(params) {
      _classCallCheck(this, Label);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }

    _createClass(Label, [{
      key: "$getLabelElement",
      value: function $getLabelElement() {
        return this.jq();
      }
    }, {
      key: "$getIconEditor",
      value: function $getIconEditor() {
        return this.queryWidget('0/image');
      }
    }, {
      key: "$getTextWidget",
      value: function $getTextWidget() {
        return this.queryWidget('0/text');
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        // Apply background to the label
        var label = this.$getLabelElement();
        var props = this.properties();
        var labelEl = label[0];
        var background = props.getValue('background');
        background.applyBackgroundToElement(labelEl); // Apply foreground to the text inside the label

        var textWidget = this.$getTextWidget();

        if (textWidget) {
          var textSpanEl = textWidget.jq()[0];
          var foreground = props.getValue('foreground');
          var enabled = this.isEnabled();

          if (enabled && foreground) {
            foreground.applyForegroundToElement(textSpanEl);
          }
        }

        var iconEditor = this.$getIconEditor();
        return iconEditor && iconEditor.dimensions();
      }
    }]);

    return Label;
  }(spandrel(function (model, _ref) {
    var props = _ref.props,
        rootElement = _ref.rootElement;
    var background = props.background,
        foreground = props.foreground,
        font = props.font,
        text = props.text,
        halign = props.halign,
        valign = props.valign,
        image = props.image,
        textIconGap = props.textIconGap,
        textToIconAlign = props.textToIconAlign,
        wordWrapEnabled = props.wordWrapEnabled,
        blink = props.blink,
        enabled = props.enabled,
        visible = props.visible,
        margin = props.margin;
    var imageOrd = baja.Ord.make(image.valueOf());

    if (imageOrd.isNull()) {
      imageOrd = null;
    }

    var label = rootElement,
        style = label.style;
    background.applyBackgroundToElement(label);

    if (!wordWrapEnabled) {
      //note that the word wrap in Wb/Hx moves down to the next line on different words than Ux
      style.whiteSpace = "nowrap";
    }

    var div = document.createElement('div');
    div.classList.add("ux-Label-content");

    if (margin && margin.isVisible()) {
      margin.applyMarginToElement(div);
    }

    label.style.justifyContent = toHAlign(halign.getTag());
    var textSpan = document.createElement('span');
    textSpan.innerText = text;
    textSpan.classList.add('-t-Label-text'); //required for multi line text

    textSpan.style.textAlign = toHAlignForText(halign.getTag());
    font.applyToElement(textSpan);

    if (enabled) {
      foreground.applyForegroundToElement(textSpan);
    }

    var textToIconAlignTag = textToIconAlign.getTag();
    var isCentered = textToIconAlignTag === 'center';
    div.style.flexDirection = toFlexDirection(textToIconAlignTag);
    var imageKid;

    if (imageOrd) {
      var imageSpan;
      imageSpan = document.createElement('span');
      imageSpan.classList.add('-t-Label-image');

      if (text && isCentered) {
        var imageUri = iconUtils.toUris(imageOrd)[0];
        var img = new Image();

        img.onload = function () {
          // the divContent we create not guaranteed to live in DOM due to diffing
          var divContent = rootElement.querySelector('.ux-Label-content');

          if (!divContent) {
            return;
          }

          divContent.classList.add('-t-Label-textToIconAlignCenter');
          divContent.style.backgroundImage = 'url("' + escapeHtml(imageUri) + '")';
          divContent.style.minWidth = img.width + "px";
          divContent.style.minHeight = img.height + "px"; //Note: when textToIconAlignTag='center, image will not have 50% opacity yet. This doesn't seem to be that common.
        };

        img.src = imageUri;
      } else {
        if (text) {
          toTextAlignMargin(imageSpan.style, textToIconAlignTag, textIconGap);
        }

        imageKid = {
          dom: imageSpan,
          type: IconEditor,
          value: [imageOrd],
          properties: {
            imageErrorBehavior: 'hide',
            draggable: false
          }
        };
      }
    }

    label.style.alignItems = toVAlign(valign.getTag());
    pxUtils.updateBlink([label], blink && visible);
    var kids = {};

    if (imageKid) {
      kids.image = imageKid;
    }

    kids.text = textSpan;
    return [{
      dom: div,
      kids: kids
    }];
  }));
  /**
   * Horizontal positioning based on css changes to `justifyContent`
   * @param {String} tag
   * @return {String}
   */

  function toHAlign(tag) {
    switch (tag) {
      case 'center':
      case 'fill':
        return 'center';

      case 'left':
        return 'flex-start';

      case 'right':
        return 'flex-end';
    }
  }
  /**
   * Horizontal positioning based on css changes to `textAlign`
   * @param {String} tag
   * @return {String}
   */


  function toHAlignForText(tag) {
    switch (tag) {
      case 'center':
      case 'fill':
        return 'center';

      case 'left':
      case 'right':
        return tag;
    }
  }
  /**
   * Horizontal positioning based on css changes to `flexDirection`
   * @param {String} tag
   * @return {string}
   */


  function toFlexDirection(tag) {
    switch (tag) {
      case 'top':
        return "column-reverse";

      case 'left':
        return 'row-reverse';

      case 'bottom':
        return "column";

      case 'right':
        return 'row';

      case 'center':
        return "";
      //this is handled by making the image the text background
    }
  }
  /**
   * When icon and text are present provide the appropriate margin to separate them.
   * @param {Object} style
   * @param {String} tag
   * @param {Number} textIconGap
   */


  function toTextAlignMargin(style, tag, textIconGap) {
    switch (tag) {
      case 'top':
        style.marginTop = textIconGap + "px";
        return;

      case 'left':
        style.marginLeft = textIconGap + "px";
        return;

      case 'bottom':
        style.marginBottom = textIconGap + "px";
        return;

      case 'right':
        style.marginRight = textIconGap + "px";
    }
  }
  /**
   * Vertical position based on css change to `alignItems`.
   * @param {String} tag
   * @return {String}
   */


  function toVAlign(tag) {
    switch (tag) {
      case 'fill':
      case 'center':
        return 'center';

      case 'top':
        return 'flex-start';

      case 'bottom':
        return 'flex-end';
    }
  }
});
