function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/GridPane
 */
define(['baja!', 'baja!bajaui:Halign,bajaui:Valign,gx:Brush', 'bajaux/spandrel', 'underscore', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, spandrel, _) {
  'use strict';

  var range = _.range;

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-GridPane',
        columnCount: 2,
        valign: baja.$('bajaui:Valign', 'center'),
        halign: baja.$('bajaui:Halign', 'center'),
        rowAlign: baja.$('bajaui:Valign', 'center'),
        columnAlign: baja.$('bajaui:Halign', 'left'),
        rowGap: 3,
        columnGap: 3,
        uniformRowHeight: false,
        uniformColumnWidth: false,
        stretchRow: -1,
        stretchColumn: -1,
        colorRows: false,
        bandBrush: baja.$('gx:Brush', 'null')
      }
    };
  };
  /**
   * bajaux implementation of `bajaui:GridPane`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/GridPane
   * @extends {module:bajaux/Widget}
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(GridPane, _spandrel);

    var _super = _createSuper(GridPane);

    function GridPane(params) {
      _classCallCheck(this, GridPane);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }

    return GridPane;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
        rootElement = _ref.rootElement;
    var halign = properties.halign,
        stretchRow = properties.stretchRow,
        valign = properties.valign;
    var style = rootElement.style;
    style.alignItems = stretchRow >= 0 ? 'stretch' : toGridAlign(valign);
    style.justifyContent = toGridAlign(halign);
    var visibleKidCount = getVisibleKidCount(model);
    return spandrel.jsx("div", {
      spandrelKey: "grid",
      className: "-t-GridPane-inner ux-preferred-size-support",
      style: createGridStyle(properties, visibleKidCount)
    }, model.getKids().map(function (kid) {
      return createCell(kid, properties);
    }));
  }));
  /**
   * @param {module:nmodule/bajaui/rc/model/UxModel} model
   * @return {Number}
   */

  function getVisibleKidCount(model) {
    return _.filter(model.getKids(), function (kid) {
      var _kid$getProperties = kid.getProperties(),
          visible = _kid$getProperties.visible;

      return visible !== false;
    }).length;
  }
  /**
   * @param {object} properties
   * @param {Number} visibleKidCount
   * @returns {object} style object for grid wrapper
   */


  function createGridStyle(properties, visibleKidCount) {
    var columnCount = properties.columnCount;
    var columnGap = properties.columnGap,
        rowGap = properties.rowGap,
        stretchColumn = properties.stretchColumn,
        stretchRow = properties.stretchRow,
        uniformColumnWidth = properties.uniformColumnWidth,
        uniformRowHeight = properties.uniformRowHeight;

    if (visibleKidCount < columnCount) {
      columnCount = visibleKidCount;
    }

    var style = {
      display: 'grid',
      gridColumnGap: columnGap + 'px',
      columnGap: columnGap + 'px',
      gridRowGap: rowGap + 'px',
      rowGap: rowGap + 'px',
      gridAutoRows: uniformRowHeight && '1fr'
    };

    if (stretchColumn >= 0 && stretchColumn < columnCount) {
      style.flex = '0 0 100%';
      style.gridTemplateColumns = repeat(0, stretchColumn, 'auto').concat('1fr').concat(repeat(stretchColumn + 1, Math.trunc(columnCount), 'auto')).join(' ');
    } else {
      style.gridTemplateColumns = "repeat(".concat(Math.trunc(columnCount), ", ").concat(uniformColumnWidth ? '1fr' : 'auto', ")");
    }

    if (stretchRow >= 0) {
      var _repeat = stretchRow > 0 ? "repeat(".concat(stretchRow, ", auto) ") : '';

      style.gridTemplateRows = "".concat(_repeat, "1fr");
    }

    return style;
  }
  /**
   * @param {module:nmodule/bajaui/rc/model/UxModel} kid
   * @param {object} gridPaneProperties
   * @returns {object} spandrel config for one cell in the grid
   */


  function createCell(kid, gridPaneProperties) {
    var columnAlign = gridPaneProperties.columnAlign,
        rowAlign = gridPaneProperties.rowAlign;

    var _kid$getProperties2 = kid.getProperties(),
        visible = _kid$getProperties2.visible; //place the actual widget in a child element of the grid cell. this is
    //because place-self does not work in Edge so rowAlign/columnAlign aren't
    //respected otherwise.


    return spandrel.jsx("div", {
      className: "-t-GridPane-cell",
      style: {
        width: !visible && '0',
        height: !visible && '0',
        alignItems: toFlexAlign(rowAlign),
        justifyContent: toFlexAlign(columnAlign)
      }
    }, spandrel.jsx("div", {
      className: "-t-GridPane-cell-content ux-use-preferred-size ux-use-preferred-min-size ux-use-preferred-max-size"
    }, spandrel.jsx("div", {
      spandrelSrc: kid,
      style: {
        flexBasis: columnAlign.getTag() === 'fill' && '100%'
      }
    })));
  }
  /**
   * @param {number} start
   * @param {number} end
   * @param {string} value
   * @returns {string[]}
   */


  function repeat(start, end, value) {
    if (start < end) {
      return range(start, end).map(function () {
        return value;
      });
    }

    return [];
  }
  /**
   * @param {baja.FrozenEnum} en
   * @returns {string} value for alignItems/justifyContent for the outer grid
   */


  function toGridAlign(en) {
    if (en.getTag() === 'fill') {
      return 'flex-start';
    }

    return toFlexAlign(en);
  }
  /**
   * @param {baja.FrozenEnum} en
   * @returns {string} value for alignItems/justifyContent
   */


  function toFlexAlign(en) {
    switch (en.getTag()) {
      case 'top':
      case 'left':
        return 'flex-start';

      case 'center':
        return 'center';

      case 'bottom':
      case 'right':
        return 'flex-end';

      case 'fill':
        return 'stretch';
    }
  }
});
