function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/CanvasPane
 */
define(['baja!', 'baja!bajaui:Halign,bajaui:ScaleMode,bajaui:Valign,gx:Size', 'bajaux/events', 'bajaux/spandrel', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/bajaui/rc/mixin/LayoutHintsSupport', 'nmodule/bajaui/rc/util/ScaledLayout'], function (baja, types, events, spandrel, Layout, LayoutHintsSupport, ScaledLayout) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-CanvasPane',
        viewSize: baja.$('gx:Size', 100, 100),
        scale: baja.$('bajaui:ScaleMode', 'none'),
        minScaleFactor: 0,
        maxScaleFactor: 0,
        halign: baja.$('bajaui:Halign', 'center'),
        valign: baja.$('bajaui:Valign', 'center'),
        background: baja.$('gx:Brush', 'null')
      }
    };
  };

  var PROPERTY_CHANGED = events.PROPERTY_CHANGED;
  /**
   * @class
   * @alias module:nmodule/bajaui/rc/ux/CanvasPane
   * @extends module:bajaux/Widget
   */

  return /*#__PURE__*/function (_spandrel) {
    _inherits(CanvasPane, _spandrel);

    var _super = _createSuper(CanvasPane);

    function CanvasPane(params) {
      var _this;

      _classCallCheck(this, CanvasPane);

      _this = _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
      LayoutHintsSupport(_assertThisInitialized(_this));
      return _this;
    }

    _createClass(CanvasPane, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.on(PROPERTY_CHANGED, function (e, ed, propName) {
          if (propName === 'layout') {
            applyLayoutToWidget(ed);
          }
        });
        return _get(_getPrototypeOf(CanvasPane.prototype), "doInitialize", this).apply(this, arguments);
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        var jq = this.jq();
        var wrapper = jq.children('.-t-CanvasPane-viewPane-wrapper');
        var viewPane = wrapper.children('.-t-CanvasPane-viewPane');

        var _this$properties$toVa = this.properties().toValueMap(),
            viewSize = _this$properties$toVa.viewSize,
            halign = _this$properties$toVa.halign,
            valign = _this$properties$toVa.valign,
            scale = _this$properties$toVa.scale,
            minScaleFactor = _this$properties$toVa.minScaleFactor,
            maxScaleFactor = _this$properties$toVa.maxScaleFactor;

        var halignTag = halign.getTag();
        var innerWidth = viewSize.getWidth() || 1;
        var innerHeight = viewSize.getHeight() || 1;
        var scaledLayout = ScaledLayout.scale(wrapper, jq, {
          innerWidth: innerWidth,
          innerHeight: innerHeight,
          halign: halignTag,
          valign: valign.getTag(),
          scale: scale.getTag(),
          minScaleFactor: minScaleFactor,
          maxScaleFactor: maxScaleFactor
        });
        wrapper.css({
          width: scaledLayout.getScaledWidth() + 'px',
          height: scaledLayout.getScaledHeight() + 'px'
        });
        var transformCss = scaledLayout.getTransformCss();
        viewPane.css({
          transform: transformCss.transform,
          // CanvasPane is flex-flow: column, so transform-origin Y should always be 50%
          transformOrigin: toOriginPercent(halignTag) + ' 50%'
        });
      }
    }, {
      key: "applyLayoutHints",
      value: function applyLayoutHints() {
        return false;
      }
    }]);

    return CanvasPane;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties,
        rootElement = _ref.rootElement;
    var viewSize = properties.viewSize,
        background = properties.background,
        halign = properties.halign,
        valign = properties.valign;
    var style = rootElement.style;
    var justifyContent = toFlexAlign(halign.getTag());
    style.alignItems = toFlexAlign(valign.getTag());
    style.justifyContent = justifyContent;
    background.applyBackgroundToElement(rootElement);
    var width = viewSize.getWidth() + 'px';
    var height = viewSize.getHeight() + 'px';
    return spandrel.jsx("div", {
      spandrelKey: "wrapper",
      className: "-t-CanvasPane-viewPane-wrapper",
      style: {
        width: width,
        height: height,
        justifyContent: justifyContent
      }
    }, spandrel.jsx("div", {
      spandrelKey: "viewPane",
      className: "-t-CanvasPane-viewPane",
      style: {
        width: width,
        height: height
      }
    }, model.getKids().map(function (kid) {
      var _kid$getProperties = kid.getProperties(),
          layout = _kid$getProperties.layout;

      var kidStyle = layout.toCss(); // NCCB-60629 Added the 'ux-scaled-layout-support' class to this div

      return spandrel.jsx("div", {
        className: "-t-CanvasPane-child bajaux-widget-container ux-preferred-size-ignore ux-scaled-layout-support",
        style: kidStyle,
        spandrelSrc: kid
      });
    })));
  }));

  function applyLayoutToWidget(widget) {
    var layout = widget.properties().getValue('layout');
    widget.jq().css(layout.toCss());
  }

  function toFlexAlign(tag) {
    switch (tag) {
      case 'top':
      case 'left':
        return 'flex-start';

      case 'center':
        return 'center';

      case 'bottom':
      case 'right':
      case 'fill':
        return 'flex-end';
    }
  }

  function toOriginPercent(tag) {
    switch (tag) {
      case 'left':
        return '0';

      case 'center':
      case 'fill':
        return '50%';

      case 'right':
        return '100%';
    }
  }
});
