function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/ux/Button
 */
define(['baja!', 'baja!bajaui:ButtonStyle', 'log!nmodule.bajaui.rc.ux.Button', 'bajaux/spandrel', 'underscore', 'nmodule/bajaui/rc/ux/bajauiEvents', 'nmodule/bajaui/rc/ux/Label'], function (baja, types, log, spandrel, _, bajauiEvents, Label) {
  'use strict';

  var omit = _.omit,
      SPACE_BAR = 32,
      logSevere = log.severe.bind(log);

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Button',
        buttonStyle: baja.$('bajaui:ButtonStyle', 'normal'),
        focusTraversable: true
      }
    };
  };
  /**
   * Button represents the javascript implementation of `bajaui:Button`. When the button is activated
   * by a user, an `ACTION_PERFORMED_EVENT` event will be emitted from this widget.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/ux/Button
   * @extends module:nmodule/bajaui/rc/ux/Label
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(Button, _spandrel);

    var _super = _createSuper(Button);

    function Button(params) {
      _classCallCheck(this, Button);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }
    /**
     * @private
     * @returns {module:bajaux/Widget}
     */


    _createClass(Button, [{
      key: "$getLabel",
      value: function $getLabel() {
        return this.queryWidget('0/0/label');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getButtonElement",
      value: function $getButtonElement() {
        return this.jq().find('button');
      }
      /**
       * Applies the background to the <button/> element of the Button widget.
       * @private
       */

    }, {
      key: "$applyBackground",
      value: function $applyBackground() {
        var button = this.$getButtonElement();
        var props = this.properties();
        var buttonTag = props.getValue('buttonStyle').getTag();

        if (button.length > 0 && buttonTag !== 'hyperlink' && buttonTag !== 'none') {
          var buttonEl = button[0];
          var background = props.getValue('background');
          background.applyBackgroundToElement(buttonEl);
        }
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        this.$applyBackground();
        var label = this.$getLabel();
        return label && label.layout();
      }
      /**
       * This method will be called when the user activates the button.
       * If overriding this method, make sure to call super to ensure the `ACTION_PERFORMED_EVENT` is emitted.
       * @returns {Promise}
       * @param {JQuery.Event} [e]
       */

    }, {
      key: "doInvokeAction",
      value: function doInvokeAction(e) {
        this.emit(bajauiEvents.ACTION_PERFORMED_EVENT, e && e.type);
        return Promise.resolve();
      }
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this = this;

        dom.on('click keyup', function (event) {
          //note that `click` is also the event callback for the enter button so that is handled here too
          var enabled = _this.isEnabled();

          if (!enabled || event.type === "keyup" && event.keyCode !== SPACE_BAR) {
            return;
          }

          dom.find(_this.$getFocusType()).focus();

          _this.doInvokeAction(event)["catch"](logSevere);
        });
        return _get(_getPrototypeOf(Button.prototype), "doInitialize", this).apply(this, arguments);
      }
      /**
       * @private
       * @returns {String}
       */

    }, {
      key: "$getFocusType",
      value: function $getFocusType() {
        return 'button';
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        //TODO: NCCB-45981 - Possibly remove this workaround after we fix this problem for all inputs in spandrel?
        var jq = this.jq();
        var focus = jq.find(this.$getFocusType()).is(":focus");
        return _get(_getPrototypeOf(Button.prototype), "render", this).apply(this, arguments).then(function (result) {
          if (focus) {
            jq.find(_this2.$getFocusType()).focus();
          }

          return result;
        });
      }
    }]);

    return Button;
  }(spandrel(function (model, _ref) {
    var properties = _ref.properties;
    var _properties = properties,
        buttonStyle = _properties.buttonStyle,
        enabled = _properties.enabled,
        focusTraversable = _properties.focusTraversable;
    var buttonTag = buttonStyle.getTag();
    var outline = document.createElement('span');
    outline.classList.add('ux-Button-outline');
    outline.classList.add('ux-Button-buttonStyle-' + buttonTag);
    var button = document.createElement('button');
    button.type = 'button';

    if (!focusTraversable) {
      button.tabIndex = -1;
    }

    if (!enabled) {
      button.disabled = true;
    }

    properties = omit(properties, 'background');
    return [{
      dom: outline,
      kids: [{
        dom: button,
        kids: {
          label: {
            dom: '<span/>',
            type: Label,
            properties: properties,
            value: model
          }
        }
      }]
    }];
  }, {
    "extends": Label
  }));
});
