function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'baja!bajaui:Layout', 'lex!bajaui', 'log!nmodule.bajaui.rc.rpc.uxBuilder', 'jquery', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/model/UxModel', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/registry/StationRegistry'], function (baja, types, lexs, log, $, Promise, _, Binding, UxModel, NullWidget, asyncUtils, StationRegistry) {
  'use strict';

  var compact = _.compact,
      difference = _.difference,
      flatten = _.flatten,
      memoize = _.memoize,
      uniq = _.uniq;

  var _lexs = _slicedToArray(lexs, 1),
      bajauiLex = _lexs[0];

  var logInfo = log.info.bind(log);
  var doRequire = asyncUtils.doRequire;
  var KIDS = 'k';
  var NAME = 'n';
  var ORD = 'o';
  var PROPERTIES = 'p';
  var TARGETS = 'ta';
  var TYPE_SPEC = 't';
  var VALUE = 'v';
  var retrieveFromServlet = memoize(function (ord) {
    return $.get('/uxBuilder/ux/data/' + baja.SlotPath.escape(String(ord)))["catch"](function (err) {
      var msg = err.responseText || bajauiLex.get('uxBuilderServlet.couldNotRetrievePxData');
      throw new Error(msg);
    });
  });
  /**
   * API Status: **Private**
   * @exports nmodule/bajaui/rc/rpc/uxBuilder
   */

  var exports = {};
  /**
   * @param {string|baja.Ord} ord
   * @returns {Promise.<module:nmodule/bajaui/rc/model/UxModel>}
   */

  exports.fromPxOrd = function (ord) {
    return log.timing(function () {
      return retrieveFromServlet(ord);
    }, 'FINE', 'Retrieved UxBuilderServlet data from {} in {}ms', ord).then(function (json) {
      return log.timing(function () {
        return exports.$pxJsonToUxModel(json);
      }, 'FINE', 'Converted UxBuilderServlet data from {} to UxModel in {}ms', ord);
    });
  };
  /**
   * @private
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxDocumentEncoding} json
   * @returns {Promise.<module:nmodule/bajaui/rc/model/UxModel>}
   */


  exports.$pxJsonToUxModel = function (_ref) {
    var props = _ref.props,
        content = _ref.content,
        _ref$typeMap = _ref.typeMap,
        typeMap = _ref$typeMap === void 0 ? {} : _ref$typeMap;
    var types = scanForTypes(content);

    if (props) {
      types = types.concat(props.map(scanForTypes));
    }

    types = difference(uniq(types), getWidgetTypeSpecs(typeMap)); //types = uniq(types);

    return baja.importTypes(types).then(function () {
      return toUxModel(content, typeMap);
    }).then(function (modelData) {
      // TODO: use symbol to avoid theoretical "pxProperties" conflict
      if (props) {
        modelData.properties.pxProperties = decodePxProperties(props);
      }

      return UxModel.make(modelData);
    });
  };
  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} widgetNode
   * @param {object} typeMap
   * @returns {Promise.<object>} resolves to a config object used to construct
   * a `UxModel`
   */


  function toUxModel(widgetNode, typeMap) {
    var name = widgetNode[NAME],
        _widgetNode$KIDS = widgetNode[KIDS],
        kids = _widgetNode$KIDS === void 0 ? [] : _widgetNode$KIDS,
        _widgetNode$PROPERTIE = widgetNode[PROPERTIES],
        properties = _widgetNode$PROPERTIE === void 0 ? [] : _widgetNode$PROPERTIE,
        typeSpec = widgetNode[TYPE_SPEC];
    return Promise.all([resolveJsWidget(typeSpec, typeMap), decodeWidgetProperties(properties.concat(kids.filter(isSimple))), decodeKids(kids, typeMap)]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 3),
          type = _ref3[0],
          properties = _ref3[1],
          _ref3$ = _ref3[2],
          widgets = _ref3$.widgets,
          bindings = _ref3$.bindings;

      return {
        name: name,
        type: type,
        properties: properties,
        kids: widgets,
        bindings: bindings
      };
    });
  }
  /**
   * Decode child components of a Px node. Widgets will be decoded to UxModel
   * children, and bindings will be decoded to their actual Component instances.
   *
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} kids
   * @param {object} typeMap
   * @returns {{ widgets: Array.<object>, bindings: Array.<baja.Component> }}
   */


  function decodeKids(kids, typeMap) {
    var widgets = [];
    var bindings = []; // we must do these in sequential order so slot order is respected. TODO NCCB-46683

    return kids.reduce(function (prom, kid) {
      return prom.then(function () {
        var typeSpec = kid[TYPE_SPEC];
        var type = baja.lt(kid[TYPE_SPEC]);
        var mapObj = typeMap[typeSpec];

        if (mapObj && mapObj.w || type && type.is('bajaui:Widget')) {
          return toUxModel(kid, typeMap).then(function (obj) {
            return widgets.push(obj);
          });
        }

        if (mapObj && mapObj.b || type && type.is('bajaui:Binding')) {
          return decodeValue(kid).then(function (comp) {
            return comp instanceof Binding && bindings.push(comp);
          });
        }
      });
    }, Promise.resolve()).then(function () {
      return {
        widgets: widgets,
        bindings: bindings
      };
    });
  }
  /**
   * @param {string} typeSpec
   * @param {object} typeMap
   * @returns {Promise.<Function>} resolves to the appropriate Widget constructor
   */


  function resolveJsWidget(typeSpec, typeMap) {
    var id = typeMap[typeSpec];
    return Promise.resolve(id && doRequire(id.js, id.bjs)).then(function (Widget) {
      if (Widget) {
        return Widget;
      }

      return StationRegistry.getInstance().resolveFirst(typeSpec, {
        hasAll: ['bajaux:IJavaScriptWidget']
      });
    }).then(function (Widget) {
      if (!Widget) {
        throw new Error('No bajaux:IJavaScriptWidget agent found for ' + typeSpec);
      }

      if (Widget === NullWidget) {
        logInfo('No bajaux:IJavaScriptWidget agent found for ' + typeSpec);
      }

      return Widget;
    });
  }
  /**
   * @param {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} properties
   * @returns {Promise.<object>} resolves to a properties object to be applied
   * to a widget
   */


  function decodeWidgetProperties(properties) {
    return Promise.all(properties.map(decodeValue)).then(function (values) {
      var props = {};
      properties.forEach(function (prop, i) {
        props[prop[NAME]] = values[i];
      });

      if (props.enabled === undefined) {
        props.enabled = true;
      }

      if (props.visible === undefined) {
        props.visible = true;
      }

      if (props.layout === undefined) {
        props.layout = baja.$('bajaui:Layout');
      }

      return props;
    });
  }
  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} valueNode
   * @returns {Promise.<baja.Value>}
   */


  function decodeValue(valueNode) {
    return isSimple(valueNode) ? decodeSimple(valueNode) : decodeComplex(valueNode);
  }

  function isSimple(valueNode) {
    var typeSpec = valueNode[TYPE_SPEC];
    var type = baja.lt(typeSpec);
    return type && type.is('baja:Simple');
  }
  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} complexNode
   * @returns {Promise.<baja.Complex>}
   */


  function decodeComplex(complexNode) {
    var _complexNode$KIDS = complexNode[KIDS],
        kids = _complexNode$KIDS === void 0 ? [] : _complexNode$KIDS,
        _complexNode$PROPERTI = complexNode[PROPERTIES],
        properties = _complexNode$PROPERTI === void 0 ? [] : _complexNode$PROPERTI,
        typeSpec = complexNode[TYPE_SPEC];
    var obj = {};
    return kids.concat(properties).reduce(function (prom, valueNode) {
      return prom.then(function () {
        return decodeValue(valueNode);
      }).then(function (value) {
        obj[valueNode[NAME]] = value;
      });
    }, Promise.resolve()).then(function () {
      return baja.$(typeSpec, obj);
    });
  }
  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} simpleNode
   * @returns {Promise.<baja.Simple>}
   */


  function decodeSimple(_ref4) {
    var value = _ref4[VALUE],
        typeSpec = _ref4[TYPE_SPEC];
    return Promise.resolve(baja.$(typeSpec).decodeAsync(value));
  }

  function decodePxProperties(props) {
    var result = {};
    props.forEach(function (prop) {
      var name = prop[NAME],
          typeSpec = prop[TYPE_SPEC],
          value = prop[VALUE],
          targets = prop[TARGETS];
      result[name] = {
        value: baja.$(typeSpec).decodeFromString(value),
        targets: targets.map(function (_ref5) {
          var ord = _ref5[ORD];
          return ord.replace(/^slot:/, '').split('/');
        })
      };
    });
    return result;
  }
  /**
   * @param {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} valueNode
   * @returns {string[]} all type specs found in the value node
   */


  function scanForTypes(valueNode) {
    var typeSpec = valueNode[TYPE_SPEC],
        _valueNode$PROPERTIES = valueNode[PROPERTIES],
        properties = _valueNode$PROPERTIES === void 0 ? [] : _valueNode$PROPERTIES,
        _valueNode$KIDS = valueNode[KIDS],
        kids = _valueNode$KIDS === void 0 ? [] : _valueNode$KIDS;
    return compact(flatten([typeSpec, properties.map(scanForTypes), kids.map(scanForTypes)]));
  }

  function getWidgetTypeSpecs(typeMap) {
    return Object.keys(typeMap).filter(function (typeSpec) {
      var obj = typeMap[typeSpec];
      return obj && obj.w;
    });
  }
  /**
   * Encoding of a Px document as provided by `UxBuilderServlet`.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxDocumentEncoding
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxPropertyEncoding>} [props] - encoding of Px properties
   * @property {module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding} content - encoding of the root widget
   * @property {object} typeMap - mapping of type specs to RequireJS info `module:nmodule/bajaui/rc/rpc/uxBuilder~RequireJSEncoding`
   */

  /**
   * Encoding of a RequireJS info provided by `UxBuilderServlet`.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~RequireJSEncoding
   * @property {String} [js] - encoding of RequireJS id
   * @property {Array.<String>} [bjs] - the RequireJS IDs necessary to preload before loading this JavaScript resource
   */

  /**
   * Encoding of a Px Property in a Px file.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxPropertyEncoding
   * @property {string} n - Px Property name
   * @property {string} t - Px Property type spec
   * @property {string} v - string encoding of value
   * @property {Array.<{ o: string }>} ta - array of ORDs (SlotPaths) this property maps to
   */

  /**
   * Encoding of a Baja value in a Px file.
   *
   * @typedef {object} module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding
   * @property {string} [n] - component name (never present for root widget)
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} p  - component properties
   * @property {string} t - widget type spec
   * @property {Array.<module:nmodule/bajaui/rc/rpc/uxBuilder~PxValueEncoding>} k - encoding of child components
   */


  return exports;
});
