function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Development**
 * @module nmodule/bajaui/rc/model/BindingList
 */
define(['Promise'], function (Promise) {
  'use strict';
  /**
   * Data structure for storing a collection of Bindings.
   * @class
   * @alias module:nmodule/bajaui/rc/model/BindingList
   */

  return /*#__PURE__*/function () {
    function BindingList() {
      var _this = this;

      var bindings = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

      _classCallCheck(this, BindingList);

      this.$bindings = bindings;
      bindings.forEach(function (binding) {
        binding.$bindingList = _this;
      });
    }
    /**
     * @returns {Array.<module:nmodule/bajaui/rc/baja/binding/Binding>}
     */


    _createClass(BindingList, [{
      key: "getBindings",
      value: function getBindings() {
        return this.$bindings.slice();
      }
      /**
       * Saves all bindings.
       * @returns {Promise}
       */

    }, {
      key: "saveAll",
      value: function saveAll() {
        return Promise.all(this.$bindings.map(function (b) {
          return b.save();
        }));
      }
      /**
       * Run an (optionally async) function against each binding in the list.
       * All function calls will run in serial, not parallel.
       * @param {Function} func function to receive the binding and the index in
       * the binding array
       * @returns {Promise.<Array.<*>>} results of each function call
       */

    }, {
      key: "map",
      value: function map(func) {
        var results = [];
        return this.$bindings.reduce(function (prom, b, i) {
          return prom.then(function () {
            return func(b, i);
          }).then(function (r) {
            return results.push(r);
          });
        }, Promise.resolve()).then(function () {
          return results;
        });
      }
    }]);

    return BindingList;
  }();
});
