function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/mixin/PreferredSizeSupport
 */
define(['bajaux/Widget', 'jquery', 'nmodule/webEditors/rc/wb/mixin/mixinUtils'], function (Widget, $, mixinUtils) {
  'use strict';

  var applyMixin = mixinUtils.applyMixin;
  var MIXIN_NAME = 'preferredSize';
  var REGEX = /^ux-(use|inherit)-preferred-(.*)$/;
  /**
   * Marks a Widget as having support for a known preferred size. To apply the
   * mixin, the widget must have a `getPreferredSize()` function implemented,
   * which returns the preferred size (an object with `width` and `height`
   * properties).
   *
   * The preferred size can be applied to DOM elements in various ways using the
   * `applySize` method.
   *
   * @mixin
   * @alias module:nmodule/bajaui/rc/mixin/PreferredSizeSupport
   */

  var PreferredSizeSupport = function PreferredSizeSupport() {};
  /**
   * @typedef module:nmodule/bajaui/rc/mixin/PreferredSizeSupport~Size
   * @property {string|number} [width]
   * @property {string|number} [height]
   * @property {string|number} [minWidth]
   * @property {string|number} [minHeight]
   * @property {string|number} [maxWidth]
   * @property {string|number} [maxHeight]
   */

  /**
   * May return a preferred size, if the widget has one. May return a falsy
   * value to indicate that no particular size is preferred.
   * @function getPreferredSize
   * @memberOf module:nmodule/bajaui/rc/mixin/PreferredSizeSupport
   * @abstract
   * @returns {module:nmodule/bajaui/rc/mixin/PreferredSizeSupport~Size|null}
   */

  /**
   * Apply the configured `preferredSize` to the given element.
   *
   * The sizing behavior is defined by the CSS classes on the element's
   * container. The container is the closest ancestor (excluding the element
   * itself) with any of the following classes applied.
   *
   * - `ux-preferred-size-support`: marks the container as supporting preferred
   *   size behavior. Use this when you intend for child widgets to size
   *   themselves according to their own preferred size. FlowPane uses this
   *   because its own layout is dictated by the preferred size of its children.
   * - `ux-preferred-size-ignore`: marks the container as preventing preferred
   *   size behavior. Use this when you intend to size child widgets regardless
   *   of their preferred size. CanvasPane uses this because its children are
   *   always sized the same regardless of their own preferred size.
   * - `ux-preferred-size-inherit`: marks an element as conforming to the
   *   preferred size behavior of an ancestor element. GridPane uses this on its
   *   `center` pane, because it should use the child's preferred size when its
   *   container needs it (such as on a FlowPane), and ignore the child's
   *   preferred size when its container forbids it (such as on a CanvasPane).
   *
   * If no container element is present in the element's ancestry, no sizes will
   * be applied.
   *
   * An element can have any of the following classes to define how the
   * preferred size is applied to it. `PreferredSizeSupport` will walk up from
   * the starting element to its container (as described above), applying CSS
   * rules as it goes. When a class is marked `use`, the associated CSS style
   * will always be applied regardless of how its container is set. When a class
   * is marked `inherit`, the associated CSS style will be applied if the
   * container is marked `support`, or not be applied if the container is marked
   * `ignore`.
   *
   * - `ux-use-preferred-size` / `ux-inherit-preferred-size`: applies `width`
   *   and `height`.
   * - `ux-use-preferred-width` / `ux-inherit-preferred-width`: applies `width`
   *   only.
   * - `ux-use-preferred-height` / `ux-inherit-preferred-height`: applies
   *   `height` only.
   * - `ux-use-preferred-min-size` / `ux-inherit-preferred-min-size`: applies
   *   `minWidth` and `minHeight`.
   * - `ux-use-preferred-min-width` / `ux-inherit-preferred-min-width`: applies
   *   `minWidth` only.
   * - `ux-use-preferred-min-height` / `ux-inherit-preferred-min-height`:
   *   applies `minHeight` only.
   * - `ux-use-preferred-max-size` / `ux-inherit-preferred-max-size`: applies
   *   `maxWidth` and `maxHeight`.
   * - `ux-use-preferred-max-width` / `ux-inherit-preferred-max-width`: applies
   *   `maxWidth` only.
   * - `ux-use-preferred-max-height` / `ux-inherit-preferred-max-height`:
   *   applies `maxHeight` only.
   * - `ux-use-preferred-flex-basis` / `ux-inherit-preferred-flex-basis: applies
   *   either the preferred width or height as `flexBasis`, depending on whether
   *   `flexFlow` is set to `row` or `column`.
   *
   * @private
   * @param {HTMLElement} el
   * @param {HTMLElement} [parentNode=el.parentNode] provide a specific parent
   * node. If given, size rules will be applied only to `el`. If not given, will
   * find `el`'s container element, and apply size rules on all elements up to
   * it.
   *
   * @example
   * <caption>Enable preferred size behavior and apply it to certain elements
   * </caption>
   *
   * // the WebWidget's preferred size will be applied as minWidth and minHeight
   * // to the widget-container element.
   * return (
   *   <div className="ux-preferred-size-support">
   *     <div className="widget-container ux-use-preferred-min-size">
   *       <WebWidget properties={{
   *         js: baja.Ord.make('file:^MyWebWidget.js'),
   *         preferredSize: baja.$('gx:Size', 640, 480)
   *       }} />
   *     </div>
   *   </div>
   * );
   *
   * @example
   * <caption>Specify preferred size behavior to be enabled or disabled based
   * on its container's wishes.</caption>
   *
   * // here, the WebWidget's preferred size will not be applied, because the
   * // class is marked 'inherit' and it is in a container that disables
   * // preferred size support.
   * return (
   *   <div className="ux-preferred-size-ignore">
   *     <div className="widget-container ux-inherit-preferred-min-size">
   *       <WebWidget properties={{
   *         js: baja.Ord.make('file:^MyWebWidget.js'),
   *         preferredSize: baja.$('gx:Size', 640, 480)
   *       }} />
   *     </div>
   *   </div>
   * );
   *
   *
   * @example
   * <caption>Applying as part of rootCssClass</caption>
   *
   * // here we apply ux-preferred-size-support to mark EdgePane as supporting
   * // preferred size behavior by default, but still allowing it to be disabled
   * // by applying ux-preferred-size-ignore to the element in which it is
   * // initialized, as CanvasPane does. if we applied ux-preferred-size-support
   * // to a child element of EdgePane, it would be difficult or unsafe to turn
   * // its preferred size behavior on or off from outside.
   *
   * const defaults = {
   *   properties: { rootCssClass: 'ux-EdgePane ux-preferred-size-support' }
   * }
   * class EdgePane extends spandrel(() => {...}) {
   *   constructor(params) { super({ params, defaults }); }
   * }
   *
   * // conversely, for FlowPane we do *not* set ux-preferred-size-support on
   * // the root, because we don't want it configurable - the FlowPane should
   * // apply its children's preferred sizes, regardless of what container the
   * // FlowPane lives in.
   */


  PreferredSizeSupport.prototype.applySize = function (el, parentNode) {
    var container = getContainer(el);
    var activeContainer = getActiveContainer(el);

    if (!container.length) {
      return;
    }

    var size = this.getPreferredSize();

    if (!size) {
      return;
    }

    if (parentNode) {
      applySize(el, parentNode, size);
    } else {
      var active = !isIgnored(activeContainer);
      var target = container[0];

      while (el) {
        var parentElement = el.parentElement;
        applySize(el, parentElement, size, active);

        if (el === target) {
          return;
        }

        el = parentElement;
      }
    }
  };

  function applySize(target, parentElement, size, active) {
    var parent = parentElement || target.parentNode;
    var style = target.style,
        classList = target.classList;
    var width = getCssValue(size, 'width');
    var height = getCssValue(size, 'height');
    var isVertical = parent && getComputedStyle(parent).flexDirection === 'column';
    classList.forEach(function (c) {
      var match = REGEX.exec(c);

      if (!match) {
        return;
      }

      var _match = _slicedToArray(match, 3),
          useOrInherit = _match[1],
          cssName = _match[2];

      if (useOrInherit === 'inherit' && !active) {
        return;
      }

      var styleName = cssNameToStyleName(cssName);

      switch (styleName) {
        case 'minWidth':
        case 'maxWidth':
        case 'minHeight':
        case 'maxHeight':
          return applyStyle(style, styleName, size);

        case 'width':
          return applyStyle(style, styleName, size, 'minWidth');

        case 'height':
          return applyStyle(style, styleName, size, 'minHeight');

        case 'size':
          applyStyle(style, 'width', size, 'minWidth');
          applyStyle(style, 'height', size, 'minHeight');
          return;

        case 'minSize':
          applyStyle(style, 'minWidth', size);
          applyStyle(style, 'minHeight', size);
          return;

        case 'maxSize':
          applyStyle(style, 'maxWidth', size);
          applyStyle(style, 'maxHeight', size);
          return;

        case 'flexBasis':
          var flexBasis = isVertical ? height : width;

          if (typeof flexBasis === 'undefined') {
            flexBasis = getCssValue(size, isVertical ? 'minHeight' : 'minWidth');
          }

          if (typeof flexBasis !== 'undefined') {
            style[styleName] = flexBasis;
          }

      }
    });
  }

  function getActiveContainer(el) {
    var decidingContainer = getContainer(el);

    while (isInherited(decidingContainer) && !isIgnored(decidingContainer)) {
      decidingContainer = getContainer(decidingContainer.parent());
    }

    return decidingContainer;
  }

  function getContainer(el) {
    return $(el).closest('.ux-preferred-size-support, .ux-preferred-size-inherit, .ux-preferred-size-ignore');
  }

  function isIgnored(container) {
    return !container.length || container.hasClass('ux-preferred-size-ignore');
  }

  function isInherited(container) {
    return container.length && container.hasClass('ux-preferred-size-inherit');
  }

  function cssNameToStyleName(name) {
    return name.replace(/-[a-z]/, function (x) {
      return x[1].toUpperCase();
    });
  }

  function getCssValue(size, name) {
    var v = size[name];
    return typeof v === 'number' ? v + 'px' : v;
  }

  function applyStyle(style, styleName, size, fallback) {
    var v = getCssValue(size, styleName);

    if (typeof v === 'undefined' && fallback) {
      v = getCssValue(size, fallback);
    }

    if (typeof v !== 'undefined') {
      style[styleName] = v;
    }
  }

  return function addPreferredSizeSupport(target) {
    if (!(target instanceof Widget)) {
      throw new Error('Widget required');
    }

    if (typeof target.getPreferredSize !== 'function') {
      throw new Error('getPreferredSize function required');
    }

    applyMixin(target, MIXIN_NAME, PreferredSizeSupport.prototype);
  };
});
