function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/LayoutEditor
 */
define(['baja!', 'baja!bajaui:Layout', 'lex!bajaui', 'bajaux/events', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, lexs, events, spandrel, Widget, Promise, Layout, fe, OrderedMapEditor, DisplayOnlyEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      bajauiLex = _lexs[0];

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var XY_UNIT_TYPES = {
    'layoutFE.absolute': Layout.ABS,
    'layoutFE.percent': Layout.PERCENT
  };
  var WIDTH_HEIGHT_UNIT_TYPES = {
    'layoutFE.absolute': Layout.ABS,
    'layoutFE.percent': Layout.PERCENT,
    'layoutFE.pref': Layout.PREF
  };
  /**
   * Widget layout that is used by Spandrel. Expects a Layout to display.
   */

  function layoutWidget() {
    var _this = this;

    var _this$state = this.state(),
        fill = _this$state.fill,
        x = _this$state.x,
        y = _this$state.y,
        w = _this$state.w,
        h = _this$state.h,
        xUnit = _this$state.xUnit,
        yUnit = _this$state.yUnit,
        wUnit = _this$state.wUnit,
        hUnit = _this$state.hUnit;

    return {
      kids: {
        layoutTable: {
          dom: "<table class=\"ux-table layoutTable ".concat(fill ? 'isFill' : '', "\"/>"),
          kids: {
            headerRow: headerRow({
              valueLabel: bajauiLex.getSafe("layoutFE.value"),
              unitsLabel: bajauiLex.getSafe("layoutFE.units")
            }),
            xRow: coordinateRow({
              coordinate: x,
              unit: xUnit,
              label: bajauiLex.getSafe("layoutFE.x")
            }),
            yRow: coordinateRow({
              coordinate: y,
              unit: yUnit,
              label: bajauiLex.getSafe("layoutFE.y")
            }),
            widthRow: dimensionRow({
              dimension: w,
              unit: wUnit,
              label: bajauiLex.getSafe("sizeFE.width"),
              hideValue: wUnit === Layout.PREF
            }),
            heightRow: dimensionRow({
              dimension: h,
              unit: hUnit,
              label: bajauiLex.getSafe("sizeFE.height"),
              hideValue: hUnit === Layout.PREF
            })
          }
        },
        fill: fillRow({
          fill: fill,
          label: bajauiLex.getSafe("layoutFE.fill")
        })
      },
      on: [[MODIFY_EVENT, '**/unit, **/fill, **/value', function () {
        return _this.applyState().then(function () {
          return _this.rerender();
        });
      }]]
    };
  }

  function headerRow(_ref) {
    var valueLabel = _ref.valueLabel,
        unitsLabel = _ref.unitsLabel;
    return "\n      <tr class=\"ux-table-head\">\n        <th></th>\n        <th>".concat(valueLabel, "</th>\n        <th>").concat(unitsLabel, "</th>\n      </tr>\n    ");
  }

  function coordinateRow(_ref2) {
    var coordinate = _ref2.coordinate,
        unit = _ref2.unit,
        label = _ref2.label;
    return {
      dom: '<tr class="ux-table-row"/>',
      kids: {
        label: "<td>".concat(label, "</td>"),
        value: {
          dom: "<td class=\"dataColumn\" />",
          value: coordinate
        },
        unit: {
          dom: "<td class=\"dataColumn\" />",
          type: OrderedMapEditor,
          value: XY_UNIT_TYPES,
          properties: {
            lexicon: 'bajaui'
          },
          loadParams: {
            selectedValue: unit
          }
        }
      }
    };
  }

  function dimensionRow(_ref3) {
    var dimension = _ref3.dimension,
        unit = _ref3.unit,
        label = _ref3.label,
        hideValue = _ref3.hideValue;
    return {
      dom: '<tr class="ux-table-row"/>',
      kids: {
        label: "<td>".concat(label, "</td>"),
        value: {
          dom: "<td class=\"dataColumn ".concat(hideValue ? "hideContents" : "", "\" />"),
          value: dimension
        },
        unit: {
          dom: "<td class=\"dataColumn\" />",
          type: OrderedMapEditor,
          value: WIDTH_HEIGHT_UNIT_TYPES,
          loadParams: {
            selectedValue: unit
          },
          properties: {
            lexicon: 'bajaui'
          }
        }
      }
    };
  }

  function fillRow(_ref4) {
    var fill = _ref4.fill,
        label = _ref4.label;
    return {
      dom: '<tr class="ux-table-row"/>',
      value: fill,
      properties: {
        trueText: label,
        falseText: label
      }
    };
  }
  /***
   * A field editor class for bajaui:Layout.  Uses Spandrel to maintain structure.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/fe/LayoutEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   */


  var LayoutEditor = /*#__PURE__*/function (_spandrel) {
    _inherits(LayoutEditor, _spandrel);

    var _super = _createSuper(LayoutEditor);

    function LayoutEditor() {
      var _this2;

      _classCallCheck(this, LayoutEditor);

      _this2 = _super.apply(this, arguments);

      if (_this2.getFormFactor() === Widget.formfactor.mini) {
        DisplayOnlyEditor.$mixin(_assertThisInitialized(_this2));
      }

      _this2.properties().add('rootCssClass', 'LayoutEditor editor');

      return _this2;
    }

    _createClass(LayoutEditor, [{
      key: "getFillWidget",
      value: function getFillWidget() {
        return this.queryWidget('fill');
      }
    }, {
      key: "getXPosWidget",
      value: function getXPosWidget() {
        return this.queryWidget('layoutTable/xRow/value');
      }
    }, {
      key: "getYPosWidget",
      value: function getYPosWidget() {
        return this.queryWidget('layoutTable/yRow/value');
      }
    }, {
      key: "getWidthWidget",
      value: function getWidthWidget() {
        return this.queryWidget('layoutTable/widthRow/value');
      }
    }, {
      key: "getHeightWidget",
      value: function getHeightWidget() {
        return this.queryWidget('layoutTable/heightRow/value');
      }
    }, {
      key: "getXUnitWidget",
      value: function getXUnitWidget() {
        return this.queryWidget('layoutTable/xRow/unit');
      }
    }, {
      key: "getYUnitWidget",
      value: function getYUnitWidget() {
        return this.queryWidget('layoutTable/yRow/unit');
      }
    }, {
      key: "getWidthUnitWidget",
      value: function getWidthUnitWidget() {
        return this.queryWidget('layoutTable/widthRow/unit');
      }
    }, {
      key: "getHeightUnitWidget",
      value: function getHeightUnitWidget() {
        return this.queryWidget('layoutTable/heightRow/unit');
      }
      /**
       * Loads a layout into the widget
       * @param {module:nmodule/bajaui/rc/baja/Layout} layout
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(layout) {
        if (!baja.hasType(layout, 'bajaui:Layout')) {
          return Promise.reject(new Error('Input value is not correct type: ' + layout));
        }

        this.state(LayoutEditor.toState(layout));
        return _get(_getPrototypeOf(LayoutEditor.prototype), "doLoad", this).apply(this, arguments);
      }
    }, {
      key: "readState",
      value: function readState() {
        return Promise.all([this.getFillWidget().read(), this.getXPosWidget().read(), this.getYPosWidget().read(), this.getWidthWidget().read(), this.getHeightWidget().read(), this.getXUnitWidget().read(), this.getYUnitWidget().read(), this.getWidthUnitWidget().read(), this.getHeightUnitWidget().read()]).then(function (_ref5) {
          var _ref6 = _slicedToArray(_ref5, 9),
              fill = _ref6[0],
              x = _ref6[1],
              y = _ref6[2],
              w = _ref6[3],
              h = _ref6[4],
              xUnit = _ref6[5],
              yUnit = _ref6[6],
              wUnit = _ref6[7],
              hUnit = _ref6[8];

          return {
            fill: fill,
            x: x,
            y: y,
            w: w,
            h: h,
            xUnit: xUnit,
            yUnit: yUnit,
            wUnit: wUnit,
            hUnit: hUnit
          };
        });
      }
    }, {
      key: "applyState",
      value: function applyState() {
        var _this3 = this;

        return this.readState().then(function (state) {
          return _this3.state(state);
        });
      }
      /**
       * Reads the value of the Layout widget.
       * @returns {Promise.<module:nmodule/bajaui/rc/baja/Layout>}
       */

    }, {
      key: "doRead",
      value: function doRead() {
        return this.readState().then(Layout.make);
      }
    }], [{
      key: "toState",
      value: function toState(layout) {
        return {
          x: layout.getX(),
          y: layout.getY(),
          w: layout.getWidth(),
          h: layout.getHeight(),
          xUnit: layout.getXUnit(),
          yUnit: layout.getYUnit(),
          wUnit: layout.getWidthUnit(),
          hUnit: layout.getHeightUnit(),
          fill: layout === Layout.FILL
        };
      }
    }]);

    return LayoutEditor;
  }(spandrel(layoutWidget, {
    manager: fe.getWidgetManager()
  }));

  return LayoutEditor;
});
