function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/binding/IValueProvider
 */
define([], function () {
  'use strict';
  /**
   * Interface representing the barest abstraction of what makes a Binding work.
   * An implementor of this interface simply provides values, keyed by property
   * name, that are to be applied to the bound object.
   *
   * Additional classes will assist in the propagation of these values to the
   * target.
   *
   * @interface
   * @alias module:nmodule/bajaui/rc/binding/IValueProvider
   */

  return /*#__PURE__*/function () {
    function IValueProvider() {
      _classCallCheck(this, IValueProvider);
    }

    _createClass(IValueProvider, [{
      key: "provide",

      /**
       * @abstract
       * @param {string} name the name of the value to retrieve
       * @param {object} [cx] any additional context useful in retrieving the
       * value from the source object
       * @returns {*|null|Promise.<*|null>} the retrieved value, or a Promise
       * that resolves to same. `null` indicates that no such value is present.
       */
      value: function provide(name, cx) {
        return null;
      }
    }]);

    return IValueProvider;
  }();
});
