function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/baja/binding/ValueBinding
 */
define(['baja!', 'lex!bajaui', 'log!nmodule/bajaui/rc/binding/baja/ValueBinding', 'Promise', 'nmodule/bajaui/rc/baja/binding/Binding', 'nmodule/bajaui/rc/binding/impl/widgetEvents', 'nmodule/converters/rc/Converter', 'nmodule/webEditors/rc/wb/ActionFirer', 'css!nmodule/bajaui/rc/bajaui'], function (baja, lexs, log, Promise, Binding, widgetEvents, Converter, ActionFirer) {
  'use strict';

  var logFine = log.fine.bind(log),
      logSevere = log.severe.bind(log);

  var _lexs = _slicedToArray(lexs, 1),
      bajauiLex = _lexs[0];
  /**
   * @class
   * @alias module:nmodule/bajaui/rc/baja/binding/ValueBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */


  return /*#__PURE__*/function (_Binding) {
    _inherits(ValueBinding, _Binding);

    var _super = _createSuper(ValueBinding);

    function ValueBinding() {
      var _this;

      _classCallCheck(this, ValueBinding);

      _this = _super.apply(this, arguments);
      _this.$converters = {};
      return _this;
    }

    _createClass(ValueBinding, [{
      key: "targetChanged",
      value: function targetChanged() {
        return this.applySummary();
      }
      /**
       * Converts the bound `BObject` to a type that is compatible with the target
       * property on the bound `Widget`.
       *
       * @param {string} name
       * @returns {Promise.<*|null>}
       */

    }, {
      key: "provide",
      value: function provide(name) {
        var converter = this.getConverter(name);
        var to = this.getWidget().properties().getDefaultValue(name);

        if (!this.isBound() || !converter || to === null) {
          return null;
        }

        var context = this.getConverterContext();
        var ordTarget = this.getOrdTarget();
        var from = ordTarget.getObject();
        return Promise["try"](function () {
          return converter.convert(from, to, context);
        }).then(function (result) {
          if (typeof result === 'string') {
            result = result.replace(/\\n/g, '\n');
          }

          return result;
        })["catch"](function (e) {
          logFine(e);
          return null;
        });
      }
      /**
       * Add event listeners for the widget:
       *
       * - on click, hyperlink
       * - add CSS to indicate whether the hyperlink is active
       *
       * @param {module:bajaux/Widget} widget
       */

    }, {
      key: "addListeners",
      value: function addListeners(widget) {
        var _this2 = this;

        var events = {
          click: function click(e) {
            var hyperlink = getHyperlink(_this2);

            if (hyperlink) {
              e.preventDefault();
              return Promise["try"](function () {
                return niagara.env.hyperlink(hyperlink);
              })["catch"](logSevere);
            }
          },
          contextmenu: function contextmenu(e) {
            if (!_this2.isBound()) {
              return;
            }

            var popupEnabled = getPopupEnabled(_this2),
                comp = _this2.getOrdTarget().getComponent(),
                hasActionsToDisplay = comp && comp.getSlots().actions().filter(isActionVisible).toArray().length > 0;

            if (popupEnabled && hasActionsToDisplay) {
              e.preventDefault();
              ActionFirer.showActionDialog(comp);
              return false;
            }
          },
          initialized: function initialized() {
            widget.jq().addClass('ux-ValueBinding').toggleClass('-t-ValueBinding-hyperlink-target', !!getHyperlink(_this2));
          },
          destroyed: function destroyed() {
            widget.jq().removeClass('ux-ValueBinding -t-ValueBinding-hyperlink-target');
          }
        };
        this.addWidgetEvents(widget, events);
      }
      /**
       * @param {string} name slot name
       * @returns {module:nmodule/converters/rc/Converter|null}
       */

    }, {
      key: "getConverter",
      value: function getConverter(name) {
        var converter = this.get(name);
        return converter instanceof Converter ? converter : null;
      }
      /**
       * Gets the context for the binding.
       * @returns {Object|null} a context for the given converter.
       */

    }, {
      key: "getConverterContext",
      value: function getConverterContext() {
        var ordTarget = this.getOrdTarget();

        if (!ordTarget || !ordTarget.getFacets) {
          return null;
        }

        return ordTarget.getFacets().toObject();
      }
      /**
       * Applies summary to the 'title' attribute of the widget HTML
       * Subclasses can override this to handle how summary is applied
       * 
       * @returns {Promise}
       */

    }, {
      key: "applySummary",
      value: function applySummary() {
        var widget = this.getWidget();
        return toShowStatus(this).then(function (statusText) {
          widget.jq().attr("title", statusText);
        });
      }
    }]);

    return ValueBinding;
  }(Binding);

  function getHyperlink(binding) {
    var hyperlink = binding.get('hyperlink');
    return !hyperlink.isNull() && hyperlink;
  }

  function getPopupEnabled(binding) {
    var popupEnabled = binding.get('popupEnabled');
    return !!popupEnabled;
  }

  function toShowStatus(binding) {
    var hyperlink = getHyperlink(binding);
    return getSummary(binding).then(function (summary) {
      if (hyperlink) {
        return bajauiLex.get({
          key: 'uxMedia.ValueBinding.showStatusWithHyperlink',
          args: [hyperlink, summary]
        });
      }

      return summary;
    });
  }

  function getSummary(binding) {
    if (!binding.isBound()) {
      return Promise.resolve("");
    }

    var summaryFormat = binding.get('summary'),
        obj = {
      object: binding.getOrdTarget().getObject()
    };
    return summaryFormat.format(obj)["catch"](function (e) {
      logFine(e);
      return "";
    });
  }

  function isActionVisible(slot) {
    return !(slot.getFlags() & baja.Flags.HIDDEN);
  }
});
