function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/baja/binding/LoadBinding
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/bajaui/rc/baja/binding/Binding'], function (baja, Promise, _, Binding) {
  'use strict';
  /**
   * A bajaux implementation of a generic Binding which calls Load if its the first LoadBinding on the Widget.
   * This can be used for Bindings which need to call `Widget.load()` on their WebWidget like `bajaui:TableBinding`.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/baja/binding/LoadBinding
   * @extends module:nmodule/bajaui/rc/baja/binding/Binding
   */

  return /*#__PURE__*/function (_Binding) {
    _inherits(LoadBinding, _Binding);

    var _super = _createSuper(LoadBinding);

    function LoadBinding() {
      _classCallCheck(this, LoadBinding);

      return _super.apply(this, arguments);
    }

    _createClass(LoadBinding, [{
      key: "$isPrimaryBinding",

      /**
       * Determines whether this binding is the first bound LoadBinding on the parent.
       * If the Widget has `ICollectionSupport`, then use the first bound LoadBounding as the primary
       * so that there is a main Widget.load Callback for the other LoadBindings to run after.
       *
       * @private
       * @returns {boolean}
       */
      value: function $isPrimaryBinding() {
        var hasCollectionSupport = this.$hasICollectionSupport();
        var firstLoadBinding = this.getBindingList().getBindings().filter(function (b) {
          return b instanceof LoadBinding && (!hasCollectionSupport || b.isBound());
        })[0];
        return firstLoadBinding === this;
      }
      /**
       *
       * @private
       * @returns {boolean}
       */

    }, {
      key: "$hasICollectionSupport",
      value: function $hasICollectionSupport() {
        var widget = this.getWidget();
        return widget && _.isFunction(widget.$hasICollectionSupport) && widget.$hasICollectionSupport();
      }
      /**
       * Determines whether or not this binding is degraded
       * @returns {boolean} true if degraded, false if not.
       */

    }, {
      key: "isDegraded",
      value: function isDegraded() {
        return !this.isBound();
      }
      /**
       * Updates the value in the bound widget if this is the primary LoadBinding
       * and the value is different than the value loaded in.
       * Secondary LoadBindings will wait for the primary load to finish,
       * then each secondary LoadBinding will resolve and load (one at a time).
       *
       * @returns {Promise} resolves if target not changed or value loaded
       */

    }, {
      key: "targetChanged",
      value: function targetChanged() {
        var widget = this.getWidget();
        var target = this.getOrdTarget();

        if (!this.isBound()) {
          return;
        }

        var targetValue = target.getObject();
        var isTargetValueDifferent = targetValue !== widget.value();
        var isPrimary = this.$isPrimaryBinding();

        if (!isPrimary && this.$hasICollectionSupport() && _.isFunction(widget.$extraLoad) && !this.$secondaryLoadSetup) {
          this.$secondaryLoadSetup = true;
          return widget.$extraLoad(target);
        }

        if (!isPrimary || !isTargetValueDifferent) {
          return Promise.resolve();
        }

        return widget.load(targetValue);
      }
      /**
       * Saves the widget's current value if this is the primary LoadBinding and
       * the widget has been modified.
       * @returns {Promise} resolves on save or if no save operation needed
       */

    }, {
      key: "save",
      value: function save() {
        var widget = this.getWidget(),
            isWidgetSaveOk = widget.isModified() && this.$isPrimaryBinding();
        return Promise.resolve(isWidgetSaveOk && widget.save());
      }
    }]);

    return LoadBinding;
  }(Binding);
});
