function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/bajaui/rc/baja/LayoutDimension
 */
define(['baja!'], function (baja) {
  'use strict';

  var ABS = 0;
  var PERCENT = 1;
  var PREF = 2;
  /**
   * BajaScript implementation of `bajaui:LayoutDimension`.
   * @class
   * @alias module:nmodule/bajaui/rc/baja/LayoutDimension
   * @extends baja.Simple
   */

  var LayoutDimension = /*#__PURE__*/function (_baja$Simple) {
    _inherits(LayoutDimension, _baja$Simple);

    var _super = _createSuper(LayoutDimension);

    /**
     * @param {object} params
     * @param {number} params.value
     * @param {number} params.unit
     */
    function LayoutDimension() {
      var _this;

      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$value = _ref.value,
          value = _ref$value === void 0 ? 0 : _ref$value,
          _ref$unit = _ref.unit,
          unit = _ref$unit === void 0 ? ABS : _ref$unit;

      _classCallCheck(this, LayoutDimension);

      _this = _super.call(this);

      if (typeof value !== 'number') {
        throw new Error('value required');
      }

      if (typeof unit !== 'number') {
        throw new Error('unit required');
      }

      if (unit !== 0 && unit !== 1 && unit !== 2) {
        throw new Error('unknown unit ' + unit);
      }

      _this.$value = value;
      _this.$unit = unit;
      return _this;
    }
    /**
     * @param {object} params
     * @param {number} params.value
     * @param {number} params.unit
     */


    _createClass(LayoutDimension, [{
      key: "make",

      /**
       * @param {object} params
       * @param {number} params.value
       * @param {number} params.unit
       */
      value: function make(params) {
        return LayoutDimension.make(params);
      }
      /**
       * @returns {number}
       */

    }, {
      key: "getValue",
      value: function getValue() {
        return this.$value;
      }
      /**
       * @returns {number}
       */

    }, {
      key: "getUnit",
      value: function getUnit() {
        return this.$unit;
      }
      /**
       * @returns {string}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        var value = this.$value;
        var unit = this.$unit;

        if (unit === PREF) {
          return 'pref';
        }

        return value.encodeToString() + (unit === PERCENT ? '%' : '');
      }
      /**
       * @param {string} str
       * @returns {module:nmodule/bajaui/rc/baja/LayoutDimension}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        var value = 0,
            unit;

        if (str === 'pref') {
          unit = PREF;
        } else {
          var _$exec = /([^%]*)(%?)$/.exec(str),
              _$exec2 = _slicedToArray(_$exec, 3),
              valueStr = _$exec2[1],
              pct = _$exec2[2];

          unit = pct === '%' ? PERCENT : ABS;
          value = baja.Double.DEFAULT.decodeFromString(valueStr);
        }

        return new LayoutDimension({
          value: value,
          unit: unit
        });
      }
      /**
       * @type {number} expresses layout in absolute pixels
       */

    }], [{
      key: "make",
      value: function make(params) {
        return new LayoutDimension(params);
      }
    }, {
      key: "ABS",
      get: function get() {
        return ABS;
      }
      /**
       * @type {number} expresses layout in percentage of container
       */

    }, {
      key: "PERCENT",
      get: function get() {
        return PERCENT;
      }
      /**
       * @type {number} expresses layout as widget's own preferred size
       */

    }, {
      key: "PREF",
      get: function get() {
        return PREF;
      }
    }]);

    return LayoutDimension;
  }(baja.Simple);

  LayoutDimension.DEFAULT = new LayoutDimension({
    value: 0,
    unit: ABS
  });
  return LayoutDimension;
});
