/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

define([
  'baja!',
  'jquery',
  'Promise',
  'nmodule/js/rc/csrf/csrfUtil',
  'baja!' +
  'bql:DynamicTimeRange,bql:FilterSet,bql:FilterEntry'
], function (baja,
             $,
             Promise,
             csrfUtil) {
  "use strict";

  /**
   * API Status: **Private**
   *
   * A set of utility functions for interacting with the query servlet.
   *
   * @exports nmodule/history/rc/queryServletUtil
   */
  var queryServletUtil = {};

  /**
   * Use the QueryServlet to find the history source and update any BIPollableHistory counts
   * @param {baja.Ord|String} ord
   * @param {boolean} live
   * @returns {Promise.<baja.Ord|undefined>}
   */
  queryServletUtil.resolveHistorySourceOrd = function (ord, live) {
    return Promise.resolve($.ajax(
      "/wsbox/query/source/" + baja.SlotPath.escape(String(ord)) + "?subscribe=" + live,
      {
        method: "POST",
        headers: {
          'x-niagara-csrfToken': csrfUtil.getCsrfToken()
        }
      }))
      .then(function (result) {
        if (!result || !result.sourceOrd) {
          return;
        }
        return baja.Ord.make("station:|" + result.sourceOrd);
      });
  };

  /**
   * Use the QueryServlet to find the last time for a history.
   * @param {baja.Ord} ord
   * @returns {Promise.<baja.AbsTime>}
   */
  queryServletUtil.resolveLastTime = function (ord) {
    return Promise.resolve($.ajax(
      "/wsbox/query/lastTime/" + baja.SlotPath.escape(String(ord)),
      {
        method: "POST",
        headers: {
          'x-niagara-csrfToken': csrfUtil.getCsrfToken()
        }
      }))
      .then(function (result) {
        return baja.AbsTime.DEFAULT.decodeFromString(result.lastTime);
      });
  };


  return queryServletUtil;
})
;
