/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/fe/PrecisionEditor
 */
define(['baja!',
        'lex!history',
        'bajaux/events',
        'jquery',
        'underscore',
        'nmodule/webEditors/rc/fe/fe',
        'nmodule/webEditors/rc/fe/baja/BaseEditor',
        'nmodule/webEditors/rc/fe/baja/OrderedMapEditor',
        'css!nmodule/history/rc/fe/historyEditors'], function (
         baja,
         lexs,
         events,
         $,
         _,
         fe,
         BaseEditor,
         OrderedMapEditor) {

  'use strict';

  var historyLex = lexs[0],

      DESTROY_EVENT = events.DESTROY_EVENT,
      DISABLE_EVENT = events.DISABLE_EVENT,
      ENABLE_EVENT = events.ENABLE_EVENT,
      INITIALIZE_EVENT = events.INITIALIZE_EVENT,
      LOAD_EVENT = events.LOAD_EVENT,
      MODIFY_EVENT = events.MODIFY_EVENT,
      READONLY_EVENT = events.READONLY_EVENT,
      WRITABLE_EVENT = events.WRITABLE_EVENT;

  var TYPES = (function () {
    var map = new baja.OrderedMap();
    map.put(historyLex.get('precision.32bit'), 32);
    map.put(historyLex.get('precision.64bit'), 64);
    return map;
  }());

  /**
   * Editor for choosing 32-bit/64-bit precision as an Integer on a history
   * config.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/history/rc/fe/PrecisionEditor
   */
  var PrecisionEditor = function PrecisionEditor(params) {
    BaseEditor.call(this, _.extend({ formFactor: 'mini' }, params));
  };
  PrecisionEditor.prototype = Object.create(BaseEditor.prototype);
  PrecisionEditor.prototype.constructor = PrecisionEditor;

  /**
   * Get the 32-bit/64-bit dropdown editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  PrecisionEditor.prototype.$getTypesEditor = function () {
    return this.jq().children('.precisionType').data('widget');
  };

  /**
   * Initializes the 32-bit/64-bit dropdown editor.
   *
   * @param {jQuery} dom
   * @returns {Promise}
   */
  PrecisionEditor.prototype.doInitialize = function (dom) {
    var that = this;

    dom.on([
      DESTROY_EVENT,
      DISABLE_EVENT, ENABLE_EVENT,
      INITIALIZE_EVENT, LOAD_EVENT,
      READONLY_EVENT, WRITABLE_EVENT
    ].join(' '), '.editor', false);

    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });

    return fe.buildFor({
      dom: $('<div class="precisionType"/>').appendTo(dom),
      type: OrderedMapEditor,
      value: TYPES
    });
  };

  /**
   * Selects 32 or 64 bits (any other values default to 32).
   *
   * @param {baja.Integer} integer
   */
  PrecisionEditor.prototype.doLoad = function (integer) {
    var mapEd = this.$getTypesEditor();
    mapEd.setSelectedValue(integer.valueOf() === 64 ? 64 : 32, true);
  };

  /**
   * Resolve 32 or 64 as a `baja.Integer`.
   *
   * @returns {Promise}
   */
  PrecisionEditor.prototype.doRead = function () {
    return this.$getTypesEditor().read().then(baja.Integer.make);
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  PrecisionEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  PrecisionEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  PrecisionEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };

  return PrecisionEditor;
});
