function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/types/EmailAddressList
 */
define(['baja!', 'nmodule/email/rc/types/EmailAddress'], function (baja, EmailAddress) {
  "use strict";
  /**
   * Representation of a `email:EmailAddressList`.
   * @alias module:nmodule/email/rc/type/EmailAddressList
   */

  var EmailAddressList = /*#__PURE__*/function (_baja$Simple) {
    _inherits(EmailAddressList, _baja$Simple);

    var _super = _createSuper(EmailAddressList);

    function EmailAddressList(addresses) {
      var _this;

      _classCallCheck(this, EmailAddressList);

      _this = _super.call(this, addresses);
      _this.$addresses = addresses || [];
      return _this;
    }

    _createClass(EmailAddressList, [{
      key: "isNull",

      /**
       * Determins whether or not the email address list is null.
       *
       * @returns {boolean}
       */
      value: function isNull() {
        return this === EmailAddressList.NULL || !this.$addresses || !this.$addresses.length;
      }
      /**
       * Creates an EmailAddressList object from the provided encoding.
       *
       * @param {string} str
       * @retrusn{module:nmodule/email/rc/type/EmailAddressList}
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (!str) {
          return EmailAddressList.NULL;
        }

        var addresses = str.split(";").map(function (emailStr) {
          return EmailAddress.DEFAULT.decodeFromString(emailStr);
        });
        return new EmailAddressList(addresses);
      }
      /**
       * Encodes the email address list to a string with a semicolon delimiter
       * between the individual address encodings.
       *
       * @returns {string}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return "";
        }

        return this.$addresses.reduce(function (encoding, currentValue, currentIndex) {
          var delimiter = currentIndex > 0 ? ";" : "";
          return encoding + delimiter + currentValue.encodeToString();
        }, "");
      }
      /**
       * Gets a copy of the address in the email address list
       *
       * @returns {Array.<module:nmodule/email/rc/type/EmailAddress>}
       */

    }, {
      key: "getAddresses",
      value: function getAddresses() {
        return this.$addresses.slice(0);
      }
    }], [{
      key: "make",
      value: function make(addresses) {
        return new EmailAddressList(addresses);
      }
    }]);

    return EmailAddressList;
  }(baja.Simple);

  EmailAddressList.DEFAULT = EmailAddressList.make([]);
  EmailAddressList.NULL = EmailAddressList.DEFAULT;
  return EmailAddressList;
});
