function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/types/EmailAddress
 */
define(['baja!', 'lex!email'], function (baja, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
      emailLex = _lexs[0];

  var containsUnallowedCharacters = function containsUnallowedCharacters(str) {
    if (!str) {
      return false;
    }

    return str.indexOf("|") !== -1 || str.indexOf(";") !== -1;
  };
  /**
   * Representation of a `email:EmailAddress`.
   * @alias module:nmodule/email/rc/type/EmailAddress
   */


  var EmailAddress = /*#__PURE__*/function (_baja$Simple) {
    _inherits(EmailAddress, _baja$Simple);

    var _super = _createSuper(EmailAddress);

    /**
     * Creates a {module:nmodule/email/rc/type/EmailAddress} Object
     *
     * @param {Object} [obj]
     * @param {string} [obj.address] the email address
     * @param {string} [obj.personal] the person's name for the provided address
     */
    function EmailAddress(obj) {
      var _this;

      _classCallCheck(this, EmailAddress);

      _this = _super.call(this, obj);

      if (!obj) {
        _this.$address = null;
        _this.$personal = null;
        return _possibleConstructorReturn(_this);
      }

      if (containsUnallowedCharacters(obj.address)) {
        throw new Error(emailLex.get('illegalAddress', obj.address));
      }

      if (containsUnallowedCharacters(obj.personal)) {
        throw new Error(emailLex.get('illegalPersonalName', obj.personal));
      }

      _this.$address = obj.address ? obj.address.trim() : null;
      _this.$personal = obj.personal || null;
      return _this;
    }
    /**
     * Creates and returns a new EmailAddress object.
     *
     * Refer to constructor for obj description.
     *
     * @param {Object} [obj]
     * @returns {module:nmodule/email/rc/type/EmailAddress}
     */


    _createClass(EmailAddress, [{
      key: "isNull",

      /**
       * Determines whether or not the email address is null.
       * @returns {boolean}
       */
      value: function isNull() {
        return !this.getAddress() && !this.getPersonal();
      }
      /**
       * Decodes the EmailAddress object using a format of:
       * address|personal
       *
       * @param {string} str
       */

    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (!str) {
          return EmailAddress.NULL;
        }

        var barIndex = str.indexOf("|");

        if (barIndex === -1) {
          return EmailAddress.make({
            address: str
          });
        }

        return EmailAddress.make({
          address: str.substring(0, barIndex),
          personal: str.substring(barIndex + 1)
        });
      }
      /**
       * Encodes the EmailAddress to a string using a format of:
       * address|personal
       *
       * @returns {string}
       */

    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this.isNull()) {
          return "";
        }

        var personal = this.getPersonal();
        var str = this.getAddress() || "";

        if (personal) {
          str += "|".concat(personal);
        }

        return str;
      }
      /**
       * The address for the EmailAddress
       *
       * @returns {string}
       */

    }, {
      key: "getAddress",
      value: function getAddress() {
        return this.$address || "";
      }
      /**
       * The personal name for the EmailAddress
       *
       * @returns {string}
       */

    }, {
      key: "getPersonal",
      value: function getPersonal() {
        return this.$personal || "";
      }
    }], [{
      key: "make",
      value: function make(obj) {
        return new EmailAddress(obj);
      }
    }]);

    return EmailAddress;
  }(baja.Simple);

  EmailAddress.DEFAULT = EmailAddress.make({
    address: null,
    personal: null
  });
  EmailAddress.NULL = EmailAddress.DEFAULT;
  return EmailAddress;
});
