/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/email/rc/mgr/EmailProtocolColumn
 */
define(['baja!', 'baja!email:IncomingAccount,email:OutgoingAccount', 'Promise', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, types, Promise, PropertyMgrColumn) {
  'use strict';
  /**
   * Manager column for the `transport` property.
   *
   * @class
   * @alias module:nmodule/email/rc/mgr/EmailProtocolColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */

  var EmailProtocolColumn = function EmailProtocolColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };

  EmailProtocolColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  EmailProtocolColumn.prototype.constructor = EmailProtocolColumn;
  /**
   * Override to return the 'store' property for an email:IncomingAccount and the 'transport' property
   * for an for an email:Outgoing Account
   * @param row
   * @returns {*} An email:Store or email:Transport object
   */

  EmailProtocolColumn.prototype.getValueFor = function (row) {
    var account = row.getSubject();
    return baja.hasType(account, 'email:OutgoingAccount') ? account.getTransport() : baja.hasType(account, 'email:IncomingAccount') ? account.getStore() : '';
  };

  return EmailProtocolColumn;
});
