/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/ace/rc/acePointManagerMenuAgent
 */
define([
    'bajaux/commands/CommandGroup',
    'nmodule/webEditors/rc/wb/menu/componentMenuAgent',
    'underscore',
    'nmodule/webEditors/rc/wb/menu/menuUtils'
  ], function (
    CommandGroup,
    componentMenuAgent,
    _,
    menuUtils
  ) {

  'use strict';

  var NEW_COMMAND_GROUP_DISPLAY_NAME = menuUtils.NEW_COMMAND_GROUP_DISPLAY_NAME;

  return function acePointManagerMenuAgent(widget, navNode) {

    // use componentMenuAgent to generate the standard context menu items
    return componentMenuAgent(widget, navNode)
      .then(function (cmdGroup) {

        // make a new CommandGroup with all the elements except the New CommandGroup
        return new CommandGroup({
          commands: _.filter(cmdGroup.getChildren(), function (child) {
            return (child.getDisplayNameFormat() !== NEW_COMMAND_GROUP_DISPLAY_NAME);
          })
        });
      });
  };
});
