/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'baja!saml:StationServiceProvider'], function (baja) {
  'use strict';
  /**
   * API Status: **Private**
   *
   * Utility methods related to SAML IdP Circle Of Trust..
   *
   * @exports nmodule/saml/rc/util/circleOfTrustUtils
   */

  var exports = {},
      STATION_INDEX = 0,
      USER_INDEX = 1,
      AUTH_SCHEME_INDEX = 2,
      PROTOTYPES_INDEX = 3;
  exports.STATION_INDEX = STATION_INDEX;
  exports.USER_INDEX = USER_INDEX;
  exports.AUTH_SCHEME_INDEX = AUTH_SCHEME_INDEX;
  exports.PROTOTYPES_INDEX = PROTOTYPES_INDEX;
  var CATEGORY_ARRAY = [];
  CATEGORY_ARRAY[STATION_INDEX] = 'station';
  CATEGORY_ARRAY[USER_INDEX] = 'user';
  CATEGORY_ARRAY[AUTH_SCHEME_INDEX] = 'authScheme';
  CATEGORY_ARRAY[PROTOTYPES_INDEX] = 'prototypes';
  exports.CIRCLE_OF_TRUST_MANAGER_SAVE_EVENT = 'CircleOfTrustManager:SAVE';
  exports.CIRCLE_OF_TRUST_MANAGER_RESET_EVENT = 'CircleOfTrustManager:RESET';
  /**
   * @returns {String} - circle of trust member category
   */

  exports.getCategory = function (value) {
    return CATEGORY_ARRAY[value];
  };
  /**
   * @returns {function} - circle of trust station row filter
   */


  exports.getStationRowFilter = function () {
    return function (row) {
      return row.getSubject().get('category') === CATEGORY_ARRAY[STATION_INDEX];
    };
  };
  /**
   * @returns {function} - circle of trust user row filter
   */


  exports.getUserRowFilter = function () {
    return function (row) {
      return row.getSubject().get('category') === CATEGORY_ARRAY[USER_INDEX];
    };
  };
  /**
   * @returns {function} - circle of trust authentication scheme row filter
   */


  exports.getAuthSchemeRowFilter = function () {
    return function (row) {
      return row.getSubject().get('category') === CATEGORY_ARRAY[AUTH_SCHEME_INDEX];
    };
  };
  /**
   * @return {Function.<boolean>} a function that can filter out rows of
   * prototypes type `module:nmodule/webEditors/rc/wb/table/model/Row`
   */


  exports.getPrototypesRowFilter = function () {
    return function (row) {
      return row.getSubject().get('category') === CATEGORY_ARRAY[PROTOTYPES_INDEX];
    };
  };
  /**
   * @returns {function} - alphabetic ascending sort function
   */


  exports.getAlphabeticSort = function () {
    return function (rowA, rowB) {
      return rowA.getSubject().get('name').toLowerCase().localeCompare(rowB.getSubject().get('name').toLowerCase());
    };
  };
  /**
   * @returns {function} - alphabetic descending sort function
   */


  exports.getReverseAlphabeticSort = function () {
    return function (rowA, rowB) {
      return rowB.getSubject().get('name').toLowerCase().localeCompare(rowA.getSubject().get('name').toLowerCase());
    };
  };

  return exports;
});
