function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/EditStationCommand
 */
define(['log!nmodule.saml.rc.util.EditStationCommand', 'lex!saml', 'Promise', 'baja!', 'bajaux/commands/Command', 'dialogs', 'nmodule/saml/rc/fe/CircleOfTrustManager', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/fe/feDialogs', 'baja!saml:StationServiceProvider', 'css!nmodule/js/rc/dialogs/dialogs'], function (log, lexs, Promise, baja, Command, dialogs, CircleOfTrustManager, compUtils, PropertySheet, Row, feDialogs) {
  'use strict';

  var samlLex = lexs[0]; //  const logSevere = log.severe.bind(log);

  var StationServiceProviderPropertySheet = /*#__PURE__*/function (_PropertySheet) {
    _inherits(StationServiceProviderPropertySheet, _PropertySheet);

    var _super = _createSuper(StationServiceProviderPropertySheet);

    function StationServiceProviderPropertySheet() {
      _classCallCheck(this, StationServiceProviderPropertySheet);

      return _super.apply(this, arguments);
    }

    _createClass(StationServiceProviderPropertySheet, [{
      key: "doLoad",
      value: function doLoad(complex) {
        var _this = this;

        return _get(_getPrototypeOf(StationServiceProviderPropertySheet.prototype), "doLoad", this).call(this, complex).then(function () {
          _this.getChildEditors().forEach(function (editor) {
            if (_this.value().getFromNiagaraNetwork() === true && editor.getKey() !== 'useEncryption') {
              editor.setReadonly(true);
            }
          });
        });
      }
    }, {
      key: "getSlotFilter",
      value: function getSlotFilter() {
        return [{
          slot: 'certificate'
        }, {
          slot: 'issuerUrl'
        }, {
          slot: 'useEncryption'
        }];
      }
    }]);

    return StationServiceProviderPropertySheet;
  }(PropertySheet);
  /**
   * Command associated with manager `Edit Station` command button, to edit an existing
   * station (StationServiceProvider) in circle of trust.
   *
   * @class
   * @alias module:nmodule/saml/rc/util/EditStationCommand
   * @extends module:bajaux/commands/Command
   */


  return /*#__PURE__*/function (_Command) {
    _inherits(EditStationCommand, _Command);

    var _super2 = _createSuper(EditStationCommand);

    /**
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     */
    function EditStationCommand(manager) {
      var _this2;

      _classCallCheck(this, EditStationCommand);

      return _this2 = _super2.call(this, {
        module: 'saml',
        lex: 'CircleOfTrust.command.edit.station',
        enabled: false,
        func: function func() {
          return _this2.$editStation(manager);
        }
      });
    }
    /**
     * Handles editing a station in Circle of Trust.
     *
     * @private
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     * @returns {Promise}
     */


    _createClass(EditStationCommand, [{
      key: "$editStation",
      value: function $editStation(manager) {
        var selectedRow = manager.getMainTable().getSelectedRows()[0],
            station = selectedRow.getSubject(),
            stationName = station.get('name'),
            serviceProviders = manager.value().getServiceProviders(),
            stationServiceProvider = serviceProviders.get(stationName);

        if (!stationServiceProvider) {
          throw new Error(samlLex.get('CircleOfTrust.commands.edit.station.error'));
        }

        return manager.getOrdBase().then(function (ordBase) {
          return feDialogs.showFor({
            value: stationServiceProvider,
            type: StationServiceProviderPropertySheet,
            properties: {
              showHeader: false,
              showControls: false,
              ordBase: ordBase
            },
            formFactor: 'mini',
            title: samlLex.get('CircleOfTrust.command.edit.station.title', stationName)
          });
        }).then(function (complexDiff) {
          if (complexDiff) {
            return stationServiceProvider;
          } else {
            return null;
          }
        });
      }
    }]);

    return EditStationCommand;
  }(Command);
});
