/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Ashutosh Chaturvedi
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/EditPrototypeCommand
 */
define(['baja!', 'Promise', 'lex!saml', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs'], function (baja, Promise, lexs, Command, feDialogs) {
  'use strict';

  var samlLex = lexs[0];
  /**
   * Get the selected item and open a dialog box to edit the value. The value, if
   * different from the current value gets added to the Circle of the Trust's prototypes
   * and the previous value is removed.
   * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
   * @returns {Promise}
   */

  function editSelectedPrototype(manager) {
    var selectedRow = manager.getMainTable().getSelectedRows()[0],
        selectedPrototypeValue = selectedRow.getSubject().get('name');
    return feDialogs.showFor({
      value: baja.SlotPath.unescape(selectedPrototypeValue),
      formFactor: 'mini',
      title: samlLex.get('CircleOfTrust.commands.editPrototypeDialog')
    }).then(function (newPrototypeValue) {
      if (newPrototypeValue === null) {
        return;
      }

      if (newPrototypeValue.trim() === '' || !baja.SlotPath.isValidName(newPrototypeValue) || newPrototypeValue !== baja.SlotPath.escape(newPrototypeValue)) {
        throw new Error(samlLex.get('CircleOfTrust.commands.prototypeDialog.enterValidName'));
      }

      var currentPrototypesArray = manager.value().getPrototypes().getSlots().toValueArray();

      if (checkForDuplicatePrototypeEntry(currentPrototypesArray, newPrototypeValue)) {
        var promises = [],
            index = currentPrototypesArray.indexOf(selectedPrototypeValue),
            prototypeItem = baja.$('baja:Component', {
          name: newPrototypeValue,
          displayName: newPrototypeValue,
          selected: true,
          category: 'prototypes'
        }),
            row = manager.getModel().makeRow(prototypeItem);
        promises.push(manager.getModel().removeRows([selectedRow]), manager.getModel().insertRows([row], index), manager.value().getPrototypes().set({
          slot: selectedPrototypeValue,
          value: newPrototypeValue
        }));
        return Promise.all(promises);
      } else {
        throw new Error(samlLex.get('CircleOfTrust.commands.prototypeDialog.nameAlreadyExist'));
      }
    })["catch"](feDialogs.error);
  }

  function checkForDuplicatePrototypeEntry(currentPrototypes, newPrototype) {
    for (var i = 0; i < currentPrototypes.length; i++) {
      if (currentPrototypes[i] === newPrototype) {
        return false;
      }
    }

    return true;
  }
  /**
   * Command to edit a selected Circle of Trust's Prototype
   * @class
   * @alias module:nmodule/saml/rc/util/EditPrototypeCommand
   * @extends module:bajaux/commands/Command
   * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
   */


  var EditPrototypeCommand = function EditPrototypeCommand(manager) {
    Command.call(this, {
      module: 'saml',
      lex: 'CircleOfTrust.commands.editPrototype',
      enabled: false,
      func: function func() {
        return editSelectedPrototype(manager);
      }
    });
  };

  EditPrototypeCommand.prototype = Object.create(Command.prototype);
  EditPrototypeCommand.prototype.constructor = EditPrototypeCommand;
  /**
   * Set the command button enabled/disabled based on the tab changed and main
   * table row selection.
   */

  EditPrototypeCommand.prototype.tabChanged = function (enabled) {
    this.setEnabled(enabled);
  };

  return EditPrototypeCommand;
});
