function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/DeleteStationCommand
 */
define(['log!nmodule.saml.rc.util.DeleteStationCommand', 'lex!saml', 'Promise', 'baja!', 'bajaux/commands/Command', 'dialogs', 'baja!baja:X509Certificate', 'baja!saml:StationServiceProvider', 'css!nmodule/js/rc/dialogs/dialogs'], function (log, lexs, Promise, baja, Command, dialogs) {
  'use strict';

  var samlLex = lexs[0];
  /**
   * Command associated with manager `Delete Station` command button, to delete an existing
   * station (StationServiceProvider) in circle of trust.
   *
   * @class
   * @alias module:nmodule/saml/rc/util/DeleteStationCommand
   * @extends module:bajaux/commands/Command
   */

  return /*#__PURE__*/function (_Command) {
    _inherits(DeleteStationCommand, _Command);

    var _super = _createSuper(DeleteStationCommand);

    /**
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     */
    function DeleteStationCommand(manager) {
      var _this;

      _classCallCheck(this, DeleteStationCommand);

      return _this = _super.call(this, {
        module: 'saml',
        lex: 'CircleOfTrust.command.delete.station',
        enabled: false,
        func: function func() {
          return _this.$deleteStation(manager);
        }
      });
    }
    /**
     * Handles deleting a station in Circle of Trust.
     *
     * @private
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     * @returns {Promise}
     */


    _createClass(DeleteStationCommand, [{
      key: "$deleteStation",
      value: function $deleteStation(manager) {
        var _this2 = this;

        var selectedRow = manager.getMainTable().getSelectedRows()[0],
            station = selectedRow.getSubject(),
            stationName = station.get('name');
        dialogs.showOkCancel({
          title: samlLex.get('CircleOfTrust.commands.dialog.delete.title', stationName),
          content: samlLex.getSafe('CircleOfTrust.commands.dialog.delete.content', stationName)
        }).ok(function () {
          return _this2.$continueDeleteStation(manager, stationName, selectedRow);
        }).cancel(function () {
          return Promise.resolve(null);
        });
      }
      /**
       * Handles deleting a station in Circle of Trust.
       *
       * @private
       * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
       * @param {string} stationName
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} selectedRow
       * @returns {Promise}
       */

    }, {
      key: "$continueDeleteStation",
      value: function $continueDeleteStation(manager, stationName, selectedRow) {
        var circleOfTrust = manager.value();
        var stationProviders = circleOfTrust.getServiceProviders();
        return stationProviders.remove(stationName).then(function () {
          return manager.getModel().removeRows([selectedRow]);
        }).then(function () {
          return manager.reSort();
        });
      }
    }]);

    return DeleteStationCommand;
  }(Command);
});
