/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Ashutosh Chaturvedi
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/DeletePrototypeCommand
 */
define(['Promise', 'bajaux/commands/Command'], function (Promise, Command) {
  'use strict';
  /**
   * Delete the selected prototype item and remove it from the Circle of Trust's
   * prototypes. Refresh the model with the updated data.
   * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
   * @returns {Promise}
   */

  function deleteSelectedPrototype(manager) {
    var selectedRow = manager.getMainTable().getSelectedRows()[0],
        selectedPrototype = selectedRow.getSubject().get('name');
    return Promise.join(manager.value().getPrototypes().remove({
      slot: selectedPrototype
    }), manager.getModel().removeRows([selectedRow]));
  }
  /**
   * Command to delete a selected Circle of Trust's Prototype
   * @class
   * @alias module:nmodule/saml/rc/util/DeletePrototypeCommand
   * @extends module:bajaux/commands/Command
   * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
   */


  var DeletePrototypeCommand = function DeletePrototypeCommand(manager) {
    Command.call(this, {
      module: 'saml',
      lex: 'CircleOfTrust.commands.deletePrototype',
      enabled: false,
      func: function func() {
        return deleteSelectedPrototype(manager);
      }
    });
  };

  DeletePrototypeCommand.prototype = Object.create(Command.prototype);
  DeletePrototypeCommand.prototype.constructor = DeletePrototypeCommand;
  /**
   * Set the command button enabled/disabled based on the tab changed and main
   * table row selection.
   */

  DeletePrototypeCommand.prototype.tabChanged = function (enabled) {
    this.setEnabled(enabled);
  };

  return DeletePrototypeCommand;
});
