function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/util/AddStationCommand
 */
define(['log!nmodule.saml.rc.util.AddStationCommand', 'lex!saml', "lex!webEditors", 'Promise', 'baja!', 'bajaux/commands/Command', 'dialogs', 'nmodule/saml/rc/fe/CircleOfTrustManager', 'nmodule/saml/rc/util/circleOfTrustUtils', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/fe/feDialogs', 'baja!baja:X509Certificate', 'baja!saml:StationServiceProvider', 'css!nmodule/js/rc/dialogs/dialogs'], function (log, lexs, lexWebEditors, Promise, baja, Command, dialogs, CircleOfTrustManager, circleOfTrustUtils, PropertySheet, Row, feDialogs) {
  'use strict';

  var samlLex = lexs[0]; //  const logSevere = log.severe.bind(log);

  var StationServiceProviderPropertySheet = /*#__PURE__*/function (_PropertySheet) {
    _inherits(StationServiceProviderPropertySheet, _PropertySheet);

    var _super = _createSuper(StationServiceProviderPropertySheet);

    function StationServiceProviderPropertySheet() {
      _classCallCheck(this, StationServiceProviderPropertySheet);

      return _super.apply(this, arguments);
    }

    _createClass(StationServiceProviderPropertySheet, [{
      key: "getSlotFilter",
      value: function getSlotFilter() {
        return [{
          slot: 'stationName'
        }, {
          slot: 'certificate'
        }, {
          slot: 'issuerUrl'
        }, {
          slot: 'useEncryption'
        }];
      }
    }]);

    return StationServiceProviderPropertySheet;
  }(PropertySheet);
  /**
   * Command associated with manager `Add Station` command button, to add a new
   * station (StationServiceProvider) to circle of trust manually.
   *
   * @class
   * @alias module:nmodule/saml/rc/util/AddStationCommand
   * @extends module:bajaux/commands/Command
   */


  return /*#__PURE__*/function (_Command) {
    _inherits(AddStationCommand, _Command);

    var _super2 = _createSuper(AddStationCommand);

    /**
     * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
     */
    function AddStationCommand(manager) {
      var _this;

      _classCallCheck(this, AddStationCommand);

      return _this = _super2.call(this, {
        module: 'saml',
        lex: 'CircleOfTrust.command.add.station',
        enabled: true,
        func: function func() {
          return _this.$addStation(manager);
        }
      });
    }
    /**
     * Assigns a base station name for the default value in the dialog.
     *
     * @param {string} baseStationName
     */


    _createClass(AddStationCommand, [{
      key: "assignBaseStationName",
      value: function assignBaseStationName(baseStationName) {
        this.$baseStationName = baseStationName;
      }
      /**
       * Handles adding a station to Circle of Trust.
       *
       * @private
       * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
       * @returns {Promise}
       */

    }, {
      key: "$addStation",
      value: function $addStation(manager) {
        var _this2 = this;

        var stationServiceProvider = this.$createStationServiceProviderTemplate(manager.value());
        return manager.getOrdBase().then(function (ordBase) {
          return feDialogs.showFor({
            value: stationServiceProvider,
            type: StationServiceProviderPropertySheet,
            properties: {
              showHeader: false,
              showControls: false,
              ordBase: ordBase
            },
            formFactor: 'mini',
            title: samlLex.get('CircleOfTrust.command.add.station')
          });
        }).then(function (complexDiff) {
          if (!complexDiff) {
            return null;
          }

          return _this2.$continueToAddStation(manager, stationServiceProvider);
        })["catch"](function (err) {
          feDialogs.error(err);
          throw err;
        });
      }
      /**
       * Handles adding a station to Circle of Trust.
       *
       * @private
       * @param {module:nmodule/saml/rc/fe/CircleOfTrustManager} manager
       * @param {saml:StationServiceProvider} stationServiceProvider
       * @returns {Promise}
       */

    }, {
      key: "$continueToAddStation",
      value: function $continueToAddStation(manager, stationServiceProvider) {
        var circleOfTrust = manager.value();
        var displayName = stationServiceProvider.get('stationName');
        var name = baja.SlotPath.escape(displayName);
        stationServiceProvider.remove('stationName');
        stationServiceProvider.setFromNiagaraNetwork(false);

        if (displayName.trim() === '') {
          throw new Error(samlLex.get('CircleOfTrust.commands.dialog.enterValidName'));
        } else if (this.$checkForDuplicateStationName(circleOfTrust, name)) {
          throw new Error(samlLex.get('CircleOfTrust.commands.dialog.nameAlreadyExists'));
        } else {
          return circleOfTrust.getServiceProviders().add({
            slot: name,
            value: stationServiceProvider
          }).then(function () {
            var station = baja.$('baja:Component', {
              name: name,
              displayName: displayName,
              selected: true,
              fromNiagaraNetwork: false,
              category: 'station'
            });
            var row = new Row(station);
            return manager.getModel().insertRows([row]);
          }).then(function () {
            return manager.reSort();
          });
        }
      }
      /**
       * Check for duplicate station names when adding a new StationServiceProvider.
       *
       * @private
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @param {string} name of station being added
       * @returns {boolean} true = `Duplicate`, false = `Unique`
       */

    }, {
      key: "$checkForDuplicateStationName",
      value: function $checkForDuplicateStationName(circleOfTrust, name) {
        return circleOfTrust.getServiceProviders().getSlots().is("saml:StationServiceProvider").toArray().some(function (serviceProvider) {
          return serviceProvider.getName() === name;
        });
      }
      /**
       * Create a StationServiceProvider Template to be edited when adding a new StationServiceProvider.
       *
       * @private
       * @param {baja.Component} circleOfTrust a `saml:CircleOfTrust` instance
       * @returns {baja.Component} StationServiceProvider
       */

    }, {
      key: "$createStationServiceProviderTemplate",
      value: function $createStationServiceProviderTemplate(circleOfTrust) {
        var stationName = '';

        if (this.$baseStationName && this.$baseStationName.trim().length > 0) {
          stationName = circleOfTrust.getServiceProviders().getUniqueName(this.$baseStationName);
        }

        return baja.$('saml:StationServiceProvider', {
          stationName: stationName,
          certificate: baja.$('baja:X509Certificate'),
          issuerUrl: 'https://jace.domain.com:443/saml/',
          useEncryption: true,
          fromNiagaraNetwork: false
        });
      }
    }]);

    return AddStationCommand;
  }(Command);
});
