/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Ashutosh Chaturvedi
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/samlPrototypeMgrAgent
 */
define(['baja!', 'baja!baja:User,saml:SamlCOTPrototypesMixIn', 'lex!saml', 'nmodule/webEditors/rc/wb/mgr/model/columns/MixinMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, MixinMgrColumn, Column) {
  'use strict';

  var samlLex = lexs[0],
      COT_PROTOTYPE_MIXIN = baja.lt('saml:SamlCOTPrototypesMixIn'),
      USER_TYPE = baja.lt('baja:User'),
      COLUMN_NAME = samlLex.get('samlPrototypes');

  var SamlPrototypesMgrColumn = function SamlPrototypesMgrColumn() {
    MixinMgrColumn.call(this, COT_PROTOTYPE_MIXIN, {
      type: USER_TYPE,
      displayName: COLUMN_NAME,
      flags: Column.flags.EDITABLE | Column.flags.UNSEEN
    });
  };

  SamlPrototypesMgrColumn.prototype = Object.create(MixinMgrColumn.prototype);
  SamlPrototypesMgrColumn.prototype.constructor = SamlPrototypesMgrColumn;
  var exports = {};

  exports.getColumns = function () {
    return [new SamlPrototypesMgrColumn()];
  };

  return exports;
});
