function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/CircleOfTrustEditor
 */
define(['jquery', 'log!nmodule/saml/rc/fe/SelectedMgrColumn', 'Promise', 'bajaux/events', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function ($, log, Promise, events, Widget, BooleanEditor, fe, PropertyMgrColumn) {
  'use strict';

  var logSevere = log.severe.bind(log);
  /**
  * Manager property column to render a checkboxes using the BooleanEditor in the manager table column.
  *
  * @class
  * @alias module:nmodule/saml/rc/fe/SelectedMgrColumn
  * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
  */

  return /*#__PURE__*/function (_PropertyMgrColumn) {
    _inherits(SelectedMgrColumn, _PropertyMgrColumn);

    var _super = _createSuper(SelectedMgrColumn);

    function SelectedMgrColumn() {
      _classCallCheck(this, SelectedMgrColumn);

      return _super.apply(this, arguments);
    }

    _createClass(SelectedMgrColumn, [{
      key: "buildCell",

      /**
       * Shows a checkbox display of the row's property value.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {JQuery} dom
       * @returns {Promise} resolves when the cell has been built
       */
      value: function buildCell(row, dom) {
        return Promise.resolve(this.getValueFor(row)).then(function (value) {
          return fe.buildFor({
            dom: dom,
            type: BooleanEditor,
            value: value,
            properties: {
              trueText: " ",
              falseText: " "
            }
          }).then(function (propertyEditor) {
            // Register MODIFY_EVENT to update underlying component.
            return propertyEditor.jq().on(events.MODIFY_EVENT, function () {
              var subject = row.getSubject();
              propertyEditor.read().then(function (value) {
                return subject.set({
                  slot: 'selected',
                  value: value
                });
              })["catch"](logSevere);
            });
          });
        });
      }
    }, {
      key: "destroyCell",

      /**
       * Destroy the BooleanEditor that was created for this cell.
       *
       * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
       * @param {JQuery} dom
       * @returns {Promise}
       */
      value: function destroyCell(row, dom) {
        return Widget["in"](dom).destroy();
      }
    }]);

    return SelectedMgrColumn;
  }(PropertyMgrColumn);
});
