function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/saml/rc/fe/CircleOfTrustEditor
 */
define(['baja!', 'bajaux/Properties', 'bajaux/Widget', 'bajaux/util/SaveCommand', 'nmodule/webEditors/rc/fe/BaseWidget', 'bajaux/events', 'bajaux/mixin/subscriberMixIn', 'bajaux/mixin/responsiveMixIn', 'jquery', 'Promise', 'nmodule/saml/rc/fe/CircleOfTrustManager', 'nmodule/webEditors/rc/wb/PropertySheet', 'nmodule/saml/rc/fe/CircleOfTrustPropertySheet', 'nmodule/saml/rc/fe/CircleOfTrustTabsWidget', 'nmodule/saml/rc/util/circleOfTrustUtils', 'css!nmodule/saml/rc/saml'], function (baja, Properties, Widget, SaveCommand, BaseWidget, events, subscriberMixin, responsiveMixIn, $, Promise, CircleOfTrustManager, PropertySheet, CircleOfTrustPropertySheet, CircleOfTrustTabsWidget, circleOfTrustUtils) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  var tpl = function tpl() {
    return "\n    <div class=\"CircleOfTrustPropertySheet\"></div>\n    <div class=\"CircleOfTrustTabs\"></div>\n  ";
  };
  /**
   * Shows information about circle of trust.
   *
   * @class
   * @alias module:nmodule/saml/rc/fe/CircleOfTrustEditor
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(CircleOfTrustEditor, _BaseWidget);

    var _super = _createSuper(CircleOfTrustEditor);

    function CircleOfTrustEditor() {
      var _this;

      _classCallCheck(this, CircleOfTrustEditor);

      _this = _super.apply(this, arguments);
      subscriberMixin(_assertThisInitialized(_this));

      _this.getCommandGroup().add(new SaveCommand());

      return _this;
    }
    /**
     * Adds child editors and initializes each of them.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(CircleOfTrustEditor, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.addClass('CircleOfTrustEditor');
        dom.html(tpl());
        dom.on(MODIFY_EVENT, '.bajaux-initialized', function () {
          _this2.setModified(true);

          return false;
        }); // Handles event triggered when circle of trust manager is saved independently from this parent
        // editor.  Currently the modified property of the editor is set to false if the editor's property
        // sheet is also not in a modified state.

        dom.on(circleOfTrustUtils.CIRCLE_OF_TRUST_MANAGER_SAVE_EVENT, '.bajaux-initialized', function () {
          if (!_this2.$propertySheet.isModified()) {
            _this2.setModified(false);
          }

          return false;
        }); // Handles event triggered when circle of trust manager is reset independently from this parent
        // editor.  Currently the modified property of the editor is set to false if the editor's property
        // sheet is also not in a modified state.

        dom.on(circleOfTrustUtils.CIRCLE_OF_TRUST_MANAGER_RESET_EVENT, '.bajaux-initialized', function () {
          if (!_this2.$propertySheet.isModified()) {
            _this2.setModified(false);
          }

          return false;
        });
        var propertySheet = this.$propertySheet = new CircleOfTrustPropertySheet();
        var tabsWidget = this.$circleOfTrustTabsWidget = new CircleOfTrustTabsWidget();
        return Promise.all([propertySheet.initialize(dom.find('.CircleOfTrustPropertySheet')), tabsWidget.initialize(dom.find('.CircleOfTrustTabs'))]);
      }
      /**
       * Loads, and reloads, child editors.
       *
       * @param {baja.Component} circleOfTrust
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(circleOfTrust) {
        return Promise.all([this.$propertySheet.load(circleOfTrust), this.$circleOfTrustTabsWidget.load(circleOfTrust)]);
      }
      /**
       * Saves the property sheet and manager values associated with this editor.
       */

    }, {
      key: "doSave",
      value: function doSave() {
        return Promise.all([this.$propertySheet.save(), this.$circleOfTrustTabsWidget.$circleOfTrustManager.save({
          currentTabValue: this.$circleOfTrustTabsWidget.$currentTabValue
        })]);
      }
      /**
       * Called when the layout of the Widget changes.
       *
       * @returns {Promise}
       */

    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }
      /**
       * Removes the class from the jq() at the end of widget life cycle
       * and destroys all child widgets.
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('CircleOfTrustEditor');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return CircleOfTrustEditor;
  }(BaseWidget);
});
