function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }

function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/dashboard/rc/ux/DashboardPane
 */
define(['baja!', 'Promise', 'lex!dashboard', 'jquery', 'underscore', 'bajaux/spandrel', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'nmodule/bajaui/rc/ux/NullWidget', 'nmodule/dashboard/rc/dashboard', 'log!nmodule.dashboard.rc.ux.DashboardPane', 'css!nmodule/dashboard/rc/dashboard'], function (baja, Promise, lexs, $, _, spandrel, profileUtils, NullWidget, dashboard, log) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      dashboardLex = _lexs[0],
      logSevere = log.severe.bind(log);

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-DashboardPane',
        id: baja.Format.make('%ord%;%viewId%;%widgetOrd%;%jsOrd%')
      }
    };
  };

  var getOrdWithoutViewQuery = profileUtils.getOrdWithoutViewQuery,
      resolveCurrentViewId = profileUtils.resolveCurrentViewId;
  /**
   * 
   * @private
   * @class
   * @alias module:nmodule/dashboard/rc/ux/DashboardPane~DashboardPaneError
   * @extends Error 
   */

  var DashboardPaneError = /*#__PURE__*/function (_Error) {
    _inherits(DashboardPaneError, _Error);

    var _super = _createSuper(DashboardPaneError);

    function DashboardPaneError() {
      _classCallCheck(this, DashboardPaneError);

      return _super.apply(this, arguments);
    }

    return DashboardPaneError;
  }( /*#__PURE__*/_wrapNativeSuper(Error));
  /**
   * `bajaux` implementation of `DashboardPane`.
   *
   * @class
   * @alias module:nmodule/dashboard/rc/ux/DashboardPane
   * @extends module:bajaux/Widget
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(DashboardPane, _spandrel);

    var _super2 = _createSuper(DashboardPane);

    function DashboardPane(params) {
      _classCallCheck(this, DashboardPane);

      return _super2.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }
    /**
     * @private
     * @returns {module:nmodule/bajaui/rc/ux/WebWidget}
     */


    _createClass(DashboardPane, [{
      key: "$getWebWidget",
      value: function $getWebWidget() {
        return this.queryWidget('0');
      }
      /**
      * Try to fetch any saved dashboard data and update the spandrel config
      * 
      * @private
      * @param {module:nmodule/bajaui/rc/model/UxModel} model
       @return {Promise}
      */

    }, {
      key: "$getConfig",
      value: function $getConfig(model) {
        var _this = this;

        var webWidgetModel = model.getKids()[0];

        if (webWidgetModel.getType() === NullWidget) {
          return Promise.reject(new DashboardPaneError(dashboardLex.get('dashboardPane.addToContent')));
        } // Add the hidden 'dashboard' property


        var dashboardProp = {
          dashboard: {
            hidden: true,
            name: 'dashboard',
            value: true,
            readonly: true,
            "transient": true,
            typeSpec: 'baja:Boolean'
          }
        };
        return resolveId(model).then(function (dashboardId) {
          var id = dashboardId;
          return _this.$getDashboardData(id).then(function (dashboardData) {
            var hasDashboardData = !_.isEmpty(dashboardData);
            Object.assign(webWidgetModel.getProperties(), dashboardProp, dashboardData);
            var config = webWidgetModel.toSpandrel('<div class="ignorePreferredSize"></div>');
            Object.assign(config, {
              hooks: {
                postLoad: function postLoad(widget) {
                  var content = widget.$getContentWidget();

                  if (content) {
                    dashboard.initialize(content.jq(), id, hasDashboardData); // postLoad of the WebWidget will not be called if there is no binding
                    // which means the toolbar will not get loaded for a dashboard pane
                    // The code below ensures toolbar is always added for the DashboardPane

                    if (content.properties().getValue('hideCommandBar')) {
                      return;
                    }

                    return widget.$getToolbar().load(content.getCommandGroup());
                  }
                }
              }
            });
            return [config];
          });
        });
      }
      /**
       * Read dashboard data saved to the station
       *
       * @private
       * @param {String} id
       * @return {Promise}
       */

    }, {
      key: "$getDashboardData",
      value: function $getDashboardData(id) {
        return getDashboardService().then(function (service) {
          return service.readDashboard(id).then(function (data) {
            var dashboardData = {};

            if (data) {
              dashboardData = JSON.parse(data);
            }

            return dashboardData;
          });
        })["catch"](function () {
          throw new DashboardPaneError(dashboardLex.get('dashboardPane.errorStarting'));
        });
      }
    }]);

    return DashboardPane;
  }(spandrel(function (model) {
    return this.$getConfig(model)["catch"](function (err) {
      if (err instanceof DashboardPaneError) {
        return [spandrel.jsx("label", null, err.message)];
      } else {
        logSevere(err);
      }
    });
  }));
  /**
   * This function resolves to a unique identifier used to read/save any configuration data
   * saved on the station.
   * Although it is a configurable property of the DashboardPane (id property), the
   * only format accepted is baja.Format.make('%ord%;%viewId%;%widgetOrd%;%jsOrd%')
   * 
   * @private
   * @inner
   * @param {module:nmodule/bajaui/rc/model/UxModel} model 
   * @returns {Promise.<String>}
   */

  function resolveId(model) {
    var webWidgetModel = model.getKids()[0];

    var _model$getProperties = model.getProperties(),
        id = _model$getProperties.id;

    var _webWidgetModel$getPr = webWidgetModel.getProperties(),
        js = _webWidgetModel$getPr.js,
        $widgetOrd = _webWidgetModel$getPr.$widgetOrd;

    var _ord = getOrdWithoutViewQuery();

    return resolveCurrentViewId().then(function (_viewId) {
      //swap the viewId if its for a BPxFile within the HxProfile.
      if (_viewId === "hx:HxPxView") {
        _viewId = "workbench:WbPxView";
      }

      return id.format({
        object: {
          ord: function ord() {
            return baja.SlotPath.escape(_ord.relativizeToSession().toString());
          },
          viewId: function viewId() {
            return baja.SlotPath.escape(_viewId);
          },
          widgetOrd: function widgetOrd() {
            return baja.SlotPath.escape($widgetOrd.toString());
          },
          jsOrd: function jsOrd() {
            return baja.SlotPath.escape(js.toString());
          }
        }
      });
    });
  }
  /**
   * Return a promise that resolves to the Station Dashboard Service.
   *
   * @private
   * @inner
   * 
   * @returns {Promise} A promise that resolves to the Dashboard Service.
   */


  function getDashboardService() {
    return baja.Ord.make("service:dashboard:DashboardService").get({
      lease: true
    });
  }
});
