function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/export/rc/Transformer
 */
define(['baja!'], function (baja) {
  'use strict';
  /**
   * API Status: **Development**
   *
   * Transform one object into another type.
   *
   * @abstract
   * @alias module:nmodule/export/rc/Transformer
   */

  var Transformer = /*#__PURE__*/function () {
    function Transformer() {
      _classCallCheck(this, Transformer);
    }

    _createClass(Transformer, [{
      key: "getDisplayName",

      /**
       * @abstract
       * @returns {string} the display name of this transformer
       */
      value: function getDisplayName() {
        throw new Error('not implemented');
      }
      /**
       * @abstract
       * @returns {string} the icon for this transformer
       */

    }, {
      key: "getIcon",
      value: function getIcon() {
        throw new Error('not implemented');
      }
      /**
       * @abstract
       * @returns {string} the mime type for the data produced by this transformer
       */

    }, {
      key: "getMimeType",
      value: function getMimeType() {
        throw new Error('not implemented');
      }
      /**
       * @abstract
       * @returns {string} the default file extension to use when saving the data produced by this transformer
       */

    }, {
      key: "getFileExtension",
      value: function getFileExtension() {
        throw new Error('not implemented');
      }
      /**
       * Transform an object into another type of data.
       *
       * @abstract
       * @param {*} object the object to be transformed
       * @param {object} [cx] transform context containing options as configured by the user
       * @returns {Promise.<*>|*} to be resolved with the transformed data
       */

    }, {
      key: "transform",
      value: function transform(object, cx) {
        throw new Error('not implemented');
      }
      /**
       * When invoking a transform operation using the Export Dialog, options can
       * be provided by the user to configure how the transform is performed.
       *
       * If this transformer should provide user-configurable options, override
       * this function to provide them in the form of a `Component`. This
       * `Component` will be shown to the user in a Property Sheet for
       * configuration.
       *
       * @param {*} transformedObject the transform object can be used to help
       * decide values on default config.
       * @see module:nmodule/export/rc/TransformOperation#getTransformedObject
       * @returns {baja.Component|Promise.<baja.Component|undefined>|undefined}
       *
       * @example
       * <caption>
       *   Provide a config option for 'prettyPrint' that uses a custom display name.
       * </caption>
       * getDefaultConfig() {
       *   var comp = baja.$('baja:Component');
       *   comp.add({
       *     slot: 'prettyPrint',
       *     value: true,
       *     cx: { displayName: 'Pretty Print' }
       *   });
       *   return comp;
       * }
       */

    }, {
      key: "getDefaultConfig",
      value: function getDefaultConfig(transformedObject) {}
      /**
       * When the user invokes the transform, the `Component` as edited by the
       * user will need to be converted to a context object to be used in the
       * `transform()` method. This function provides a hook to perform extra
       * processing during that conversion.
       *
       * By default, will return a simple mapping of the `Component`'s slot names
       * to their values.
       *
       * @param {baja.Component|object} config the config component as edited by the user
       * @returns {object|Promise<object>} the context object
       */

    }, {
      key: "getExportContextObject",
      value: function getExportContextObject(config) {
        if (!(config instanceof baja.Component)) {
          return config || {};
        }

        return config.getSlots().toValueMap();
      }
      /**
       * By default, all Transformers supply data to an ExportDestinationType.
       *
       * If there is nothing to supply to a destination, then return false and
       * this will instruct the UI to show no ExportDestinationTypes.
       *
       * @returns {boolean}
       * @see module:nmodule/export/rc/ExportDestinationType
       */

    }, {
      key: "isSupplier",
      value: function isSupplier() {
        return true;
      }
    }]);

    return Transformer;
  }();

  return Transformer;
});
