function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/**
 * @module nmodule/export/rc/TransformOperationProvider
 */
define([], function () {
  'use strict';
  /**
   * API Status: **Development**
   *
   * A provider for TransformOperations.
   *
   * @interface
   * @alias module:nmodule/export/rc/TransformOperationProvider
   */

  var TransformOperationProvider = /*#__PURE__*/function () {
    function TransformOperationProvider() {
      _classCallCheck(this, TransformOperationProvider);
    }

    _createClass(TransformOperationProvider, [{
      key: "getTransformOperations",

      /**
       * Resolve an Array of the available TransformOperations to the given
       * subject.
       *
       * Note that the subject received may depend on how the transform was
       * invoked. For instance, if performing an Export command on a node in the
       * nav tree, the subject might be a Component. If performing an Export
       * command by using the Export button in the toolbar, the subject would be
       * the Widget currently being viewed. Be sure to perform the appropriate
       * type checking on the input subject.
       *
       * @abstract
       * @param {*} subject
       * @returns {Promise.<Array.<module:nmodule/export/rc/TransformOperation>>}
       */
      value: function getTransformOperations(subject) {
        throw new Error('not implemented');
      }
    }]);

    return TransformOperationProvider;
  }();

  return TransformOperationProvider;
});
