function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/export/rc/TransformOperation
 */
define(['Promise'], function (Promise) {
  'use strict';
  /**
   * API Status: **Development**
   *
   * A TransformOperation encapsulates the lifecycle of transforming an object
   * into data, and sending that data to a destination.
   *
   * @class
   * @alias module:nmodule/export/rc/TransformOperation
   */

  var TransformOperation = /*#__PURE__*/function () {
    /**
     * @param {module:nmodule/export/rc/Transformer} transformer the transformer that will perform the transform operation
     * @param {*} object the object to be transformed
     */
    function TransformOperation(transformer, object) {
      _classCallCheck(this, TransformOperation);

      this.$transformer = transformer;
      this.$transformedObject = object;
    }
    /**
     * @returns {module:nmodule/export/rc/Transformer} the transformer that will perform the transform operation
     */


    _createClass(TransformOperation, [{
      key: "getTransformer",
      value: function getTransformer() {
        return this.$transformer;
      }
      /**
       * @returns {*} the object to be transformed
       */

    }, {
      key: "getTransformedObject",
      value: function getTransformedObject() {
        return this.$transformedObject;
      }
      /**
       * @param {object} cx transform context. This will be passed to the {@link module:nmodule/export/rc/Transformer#transform transform()} method.
       * @returns {Promise}
       */

    }, {
      key: "doTransform",
      value: function doTransform(cx) {
        return Promise.resolve(this.getTransformer().transform(this.getTransformedObject(), cx));
      }
      /**
       * @returns {String} the display name to be shown to the user to allow him or her to choose to perform this transform operation
       */

    }, {
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$transformer.getDisplayName();
      }
    }]);

    return TransformOperation;
  }();

  return TransformOperation;
});
