function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @module nmodule/export/rc/ExportDestinationType
 */
define(['baja!'], function (baja) {
  'use strict';
  /**
   * API Status: **Development**
   *
   * A destination type describes where a transform operation may send its output.
   * Examples include: the file system; the clipboard; the cloud; an external
   * application.
   *
   * When sending transformed data to a destination, there are three touchpoints
   * in that workflow:
   *
   * - `checkValid()`: does this destination even work? Example: a destination
   *   that sends data to the clipboard is not valid in a browser that does not
   *   support the Clipboard API, so don't even present it to the user as an
   *   option.
   * - `prepare()`: does this destination work for the transform as requested
   *   by the user? Example: a destination that writes to the file system would
   *   prompt the user to make sure it's okay to overwrite a particular file.
   * - `transform()`: All systems go - write the data.
   *
   * @abstract
   * @alias module:nmodule/export/rc/ExportDestinationType
   */

  var ExportDestinationType = /*#__PURE__*/function () {
    function ExportDestinationType() {
      _classCallCheck(this, ExportDestinationType);
    }

    _createClass(ExportDestinationType, [{
      key: "checkValid",

      /**
       * @throws {Error} if this destination is not valid in the current environment
       */
      value: function checkValid() {}
      /**
       * @abstract
       * @returns {string} display name for the destination
       */

    }, {
      key: "getDisplayName",
      value: function getDisplayName() {
        throw new Error('not implemented');
      }
      /**
       * Perform any necessary preparation before the actual transform. This is a
       * hook for things like user prompts ("do you want to overwrite this file?",
       * etc). By default, simply returns true.
       *
       * @param {module:nmodule/export/rc/TransformOperation} transformOp the transform operation
       * @param {object} cx the export context
       * @returns {Promise.<boolean>|boolean} return or resolve `true` to indicate
       * that the transform should proceed. Return `false` to indicate that the
       * transform was canceled (either by the user, or conditions simply do not
       * support this transform/destination). Throw or reject only in case of an
       * unexpected error condition.
       */

    }, {
      key: "prepare",
      value: function prepare(transformOp, cx) {
        return true;
      }
      /**
       * Perform the entire transformation operation: execute the transform
       * to obtain the transformed data, and send that data to this destination.
       *
       * *Important note*: this method should not require any user interaction.
       * It should only be data-in to data-out. Any user prompts should be
       * completed in `prepare()`.
       *
       * @abstract
       * @param {module:nmodule/export/rc/TransformOperation} transformOp the transform operation
       * @param {object} cx the export context
       * @returns {Promise|*}
       */

    }, {
      key: "transform",
      value: function transform(transformOp, cx) {
        throw new Error('not implemented');
      }
      /**
       * When invoking a transform operation using the Export Dialog, options can
       * be provided by the user to configure how to send the transformed data to
       * its destination.
       *
       * If this destination should provide user-configurable options, override
       * this function to provide them in the form of a `Component`. This
       * `Component` will be shown to the user in a Property Sheet for
       * configuration.
       * 
       * @param {module:nmodule/export/rc/TransformOperation} transformOp The transform operation this destination type is a target for
       * @returns {baja.Component|Promise<baja.Component|undefined>|undefined} The destination config object.
       */

    }, {
      key: "getDestinationConfig",
      value: function getDestinationConfig(transformOp) {}
      /**
       * When the user invokes the transform, the `Component` as edited by the
       * user will need to be converted to a context object to be used in the
       * `transform()` method. This function provides a hook to perform extra
       * processing during that conversion.
       *
       * By default, will return a simple mapping of the `Component`'s slot names
       * to their values.
       * 
       * @param {baja.Component} config The destination config component as edited by the user
       * @returns {object|Promise<object>} the context object
       */

    }, {
      key: "getDestinationContextObject",
      value: function getDestinationContextObject(config) {
        if (!(config instanceof baja.Component)) {
          return config || {};
        } else {
          return config.getSlots().toValueMap();
        }
      }
    }]);

    return ExportDestinationType;
  }();

  return ExportDestinationType;
});
