function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/user/UserManagerMgrModel
 */
define(['baja!', 'baja!baja:PasswordAuthenticator,baja:User', 'Promise', 'underscore', 'nmodule/webEditors/rc/servlets/password', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/model/mgrAgents', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource', 'nmodule/webEditors/rc/wb/util/user/AuthenticatorMgrColumn', 'nmodule/webEditors/rc/wb/util/user/ExpirationMgrColumn'], function (baja, types, Promise, _, password, MgrTypeInfo, MgrModel, mgrAgents, NameMgrColumn, PropertyMgrColumn, Column, ContainerComponentSource, AuthenticatorMgrColumn, ExpirationMgrColumn) {
  'use strict';

  var USER_TYPE = baja.lt('baja:User'),
      EDITABLE = Column.flags.EDITABLE,
      UNSEEN = Column.flags.UNSEEN,
      defaultPassword = baja.$('baja:PasswordAuthenticator').get('password'); ////////////////////////////////////////////////////////////////
  // Column definitions
  ////////////////////////////////////////////////////////////////

  function toColumn(slot, params) {
    params = params || {};
    var Ctor = params.ctor || PropertyMgrColumn,
        flags = params.flags || EDITABLE;
    return new Ctor(slot, {
      type: USER_TYPE,
      flags: flags
    });
  }

  var COLUMNS = [new NameMgrColumn({
    flags: EDITABLE
  }), toColumn('fullName'), toColumn('enabled'), toColumn('expiration', {
    ctor: ExpirationMgrColumn
  }), toColumn('lockOut', {
    flags: UNSEEN
  }), toColumn('roles', {
    flags: EDITABLE | UNSEEN
  }), toColumn('allowConcurrentSessions'), toColumn('autoLogoffSettings'), toColumn('networkUser'), toColumn('prototypeName'), toColumn('language'), toColumn('authenticationSchemeName'), toColumn('authenticator', {
    ctor: AuthenticatorMgrColumn,
    flags: EDITABLE | UNSEEN
  }), toColumn('email'), toColumn('cellPhoneNumber', {
    flags: EDITABLE | UNSEEN
  }), toColumn('facets', {
    flags: EDITABLE | UNSEEN
  }), toColumn('navFile', {
    flags: EDITABLE | UNSEEN
  })];
  /**
   * Get component name.
   *
   * @param {baja.Complex} comp
   * @returns {String}
   */

  function toName(comp) {
    return comp.getName();
  }
  /**
   * Get the user's password as a string, then reset the password to the
   * default so BajaScript will not attempt to encode it and send it over the
   * wire.
   *
   * @param {baja.Complex} user
   * @returns {String}
   */


  function extractPassword(user) {
    var authenticator = user.get('authenticator'),
        pw = authenticator.get('password'); // the password could be null if the clientCertAuthenticator is configured

    if (pw !== null) {
      //if no password entered, treat it as blank.
      if (pw.equals(defaultPassword)) {
        pw = baja.$('baja:Password');
      }

      authenticator.set({
        slot: 'password',
        value: defaultPassword
      });
      return pw.encodeToString();
    }

    return null;
  }
  /**
   * Get any passwords on the user's authenticator in addition to the 'password'
   * property and set them over RPC with the provided batch, then reset the password
   * to the default so BajaScript will not attempt to encode it and send it over the wire.
   *
   * @param {baja.Complex} user
   * @param {baja.Component} userService
   * @param {baja.comm.Batch} batch
   * @returns {Promise}
   */


  function setExtraPasswords(user, userService, batch) {
    var authenticator = user.get('authenticator'),
        promises = [],
        authenticatorOrd = baja.Ord.make(userService.getNavOrd() + '/' + toName(user) + '/authenticator');
    authenticator.getSlots().properties().is("baja:Password").each(function (slot) {
      if (slot.getName() !== 'password') {
        var pw = authenticator.get(slot);

        if (!pw.equals(defaultPassword)) {
          promises.push(password.setPassword(pw.encodeToString(), slot.getName(), authenticatorOrd, {
            batch: batch
          }));
        }

        authenticator.set({
          slot: slot,
          value: defaultPassword
        });
      }
    });
    return Promise.all(promises);
  }
  /**
   * `MgrModel` for the User Manager. Don't instantiate directly; use the `make`
   * method.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/MgrModel
   * @alias module:nmodule/webEditors/rc/wb/util/user/UserManagerMgrModel
   */


  var UserManagerMgrModel = function UserManagerMgrModel() {
    MgrModel.apply(this, arguments);
  };

  UserManagerMgrModel.prototype = Object.create(MgrModel.prototype);
  UserManagerMgrModel.prototype.constructor = UserManagerMgrModel;
  /**
   * Create a `UserManagerMgrModel` instance with the appropriate columns.
   *
   * @param {baja.Component} userService
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/util/user/UserManagerMgrModel>}
   */

  UserManagerMgrModel.make = function (userService) {
    return Promise.all([MgrTypeInfo.make([USER_TYPE]), mgrAgents.getMixInColumns(USER_TYPE)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          newTypes = _ref2[0],
          mixinCols = _ref2[1];

      return new UserManagerMgrModel({
        columns: COLUMNS.concat(mixinCols),
        componentSource: new ContainerComponentSource({
          container: userService,
          filter: ['baja:User']
        }),
        newTypes: newTypes
      });
    });
  };
  /**
   * When creating a new user, copy the default prototype off of
   * the user service. See `wbutil:UserManager$model#newInstance`.
   *
   * @param {module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo} typeInfo
   * @returns {baja.Component} a `baja:User` cloned from the default
   * prototype.
   */


  UserManagerMgrModel.prototype.newInstance = function (typeInfo) {
    //user manager always uses a UserService as component container.
    var componentSource = this.getComponentSource(),
        userService = componentSource.getContainer(),
        prototypes = userService.get('userPrototypes'); // noinspection JSValidateTypes

    return prototypes.get('defaultPrototype').newCopy();
  };
  /**
   * Before writing the users up to the station, wipe all the passwords off
   * (BajaScript will not encode them). After the users are added, then send
   * the passwords up through the designated `ChangeUserPasswordServlet`.
   *
   * @param {Array.<baja.Component>} users
   * @returns {Promise}
   */


  UserManagerMgrModel.prototype.addInstances = function (users) {
    var names = [],
        passwords = [],
        userService = this.getComponentSource().getContainer(),
        batch = new baja.comm.Batch(),
        extraPasswordPromise = Promise.all(_.map(users, function (user) {
      return setExtraPasswords(user, userService, batch);
    }));
    users.forEach(function (user) {
      var password = extractPassword(user);

      if (password !== null) {
        names.push(toName(user));
        passwords.push(password);
      }
    });
    return MgrModel.prototype.addInstances.apply(this, arguments).then(function () {
      if (names.length > 0) {
        var promise = Promise.all([password.changePasswords(names, passwords, userService, {
          batch: batch
        }), extraPasswordPromise]);
        return batch.commit(promise);
      }

      return null;
    });
  };

  return UserManagerMgrModel;
});
