/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/user/ExpirationMgrColumn
 */
define(['baja!', 'lex!webEditors', 'Promise', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn'], function (baja, lexs, Promise, PropertyMgrColumn) {
  'use strict';

  var webEditorsLex = lexs[0];
  /**
   * Manager column for the `expiration` property.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/user/ExpirationMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn
   */

  var ExpirationMgrColumn = function ExpirationMgrColumn() {
    PropertyMgrColumn.apply(this, arguments);
  };

  ExpirationMgrColumn.prototype = Object.create(PropertyMgrColumn.prototype);
  ExpirationMgrColumn.prototype.constructor = ExpirationMgrColumn;
  /**
   * Show a readable string for "never" or "expired".
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @param {JQuery} dom
   * @returns {Promise}
   */

  ExpirationMgrColumn.prototype.buildCell = function (row, dom) {
    var expiration = this.getValueFor(row),
        str;

    if (expiration.getJsDate().getTime() === 0) {
      str = webEditorsLex.get('UserManager.columns.expiration.never');
    } else if (expiration.getJsDate().getTime() < new Date().getTime()) {
      str = webEditorsLex.get('UserManager.columns.expiration.expired');
    } else {
      str = expiration.toDateTimeString({
        show: baja.TimeFormat.SHOW_DATE
      });
    }

    return Promise.resolve(str).then(function (s) {
      dom.text(s);
    });
  };

  return ExpirationMgrColumn;
});
