/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/role/roleHierarchiesMgrAgent
 */
define(['baja!', 'baja!baja:Role,hierarchy:RoleHierarchies', 'lex!hierarchy', 'nmodule/webEditors/rc/wb/mgr/model/columns/MixinMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, MixinMgrColumn, Column) {
  'use strict';

  var hierarchyLex = lexs[0],
      ROLE_TYPE = baja.lt('baja:Role'),
      ROLE_HIERARCHIES_TYPE = baja.lt('hierarchy:RoleHierarchies'),
      COLUMN_NAME = hierarchyLex.get('roleHierarchies'),
      OBJECT_ICON = '/module/icons/x16/object.png';

  var RoleHierarchiesMgrColumn = function RoleHierarchiesMgrColumn() {
    MixinMgrColumn.call(this, ROLE_HIERARCHIES_TYPE, {
      type: ROLE_TYPE,
      displayName: COLUMN_NAME,
      flags: Column.flags.EDITABLE
    });
  };

  RoleHierarchiesMgrColumn.prototype = Object.create(MixinMgrColumn.prototype);
  RoleHierarchiesMgrColumn.prototype.constructor = RoleHierarchiesMgrColumn;
  /**
   * Return the icon to be used for the column in the batch component editor.
   * @returns {String}
   */

  RoleHierarchiesMgrColumn.prototype.getColumnIcon = function () {
    return OBJECT_ICON;
  };

  var exports = {};

  exports.getColumns = function () {
    return [new RoleHierarchiesMgrColumn()];
  };

  return exports;
});
