/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/role/RoleNameMgrColumn
 */
define(['baja!', 'baja!baja:Role', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn'], function (baja, types, NameMgrColumn) {
  'use strict';

  var ROLE = 'baja:Role',
      OBJECT_ICON = '/module/icons/x16/object.png';
  /**
   * Column for showing a role component's display name.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/role/RoleNameMgrColumn
   * @extends module:nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn
   */

  var RoleNameMgrColumn = function RoleNameMgrColumn(params) {
    NameMgrColumn.call(this, params);
  };

  RoleNameMgrColumn.prototype = Object.create(NameMgrColumn.prototype);
  RoleNameMgrColumn.prototype.constructor = RoleNameMgrColumn;
  /**
   * Return the role component's display name.
   *
   * @param {module:nmodule/webEditors/rc/wb/table/model/Row} row
   * @returns {String} the component's display name
   * @throws {Error} if the row does not actually have a `baja:Role` loaded
   */

  RoleNameMgrColumn.prototype.getValueFor = function (row) {
    var role = row.getSubject();

    if (!baja.hasType(role, ROLE)) {
      throw new Error('baja:Role required, got: ' + role.getType());
    } // as per BRoleManager.RoleNameColumn


    if (role.getName().equals('Admin')) {
      return 'admin';
    }

    if (role.getName().equals('Guest')) {
      return 'guest';
    }

    return NameMgrColumn.prototype.getValueFor.call(this, row);
  };
  /**
   * Return the icon to be used for the column in the batch component editor.
   * @returns {String}
   */


  RoleNameMgrColumn.prototype.getColumnIcon = function () {
    return OBJECT_ICON;
  };

  return RoleNameMgrColumn;
});
