/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/mobileWebProfileConfigMgrAgent
 */
define(['baja!', 'baja!baja:User,web:MobileWebProfileConfig', 'lex!web', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/wb/mgr/model/MgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/MixinMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, types, lexs, BaseEditor, MgrColumn, MixinMgrColumn, Column) {
  'use strict';

  var webLex = lexs[0],
      userType = baja.lt('baja:User'),
      SHOULD_VALIDATE = BaseEditor.SHOULD_VALIDATE;

  var MobileWebProfileConfigMgrColumn = function MobileWebProfileConfigMgrColumn() {
    MixinMgrColumn.call(this, baja.lt('web:MobileWebProfileConfig'), {
      type: userType,
      displayName: webLex.get('mobileWebProfileConfig'),
      flags: Column.flags.EDITABLE | Column.flags.UNSEEN
    });
  };

  MobileWebProfileConfigMgrColumn.prototype = Object.create(MixinMgrColumn.prototype);
  MobileWebProfileConfigMgrColumn.prototype.constructor = MobileWebProfileConfigMgrColumn;

  MobileWebProfileConfigMgrColumn.prototype.getConfigFor = function (rows) {
    var config = MixinMgrColumn.prototype.getConfigFor.apply(this, arguments);
    var props = {
      alwaysExpand: true
    };
    props[SHOULD_VALIDATE] = true;
    config.properties = props;
    return config;
  };

  MobileWebProfileConfigMgrColumn.prototype.commit = function (value, row, params) {
    var user = row.getSubject(),
        name = this.getName(),
        config = user.get(name),
        batch = params && params.batch,
        progressCallback = params && params.progressCallback,
        prom;

    if (config.isMounted()) {
      prom = config.serverSideCall({
        typeSpec: 'webEditors:TypeConfigSSCHandler',
        methodName: 'syncFrom',
        value: value,
        batch: batch
      });
    } else {
      prom = user.set({
        slot: name,
        value: value,
        batch: batch
      });
    }

    if (progressCallback) {
      progressCallback(MgrColumn.COMMIT_READY);
    }

    return prom;
  };

  var exports = {}; //TODO: requireExactTypeMatch()

  exports.getColumns = function () {
    return [new MobileWebProfileConfigMgrColumn()];
  };

  return exports;
});
