/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/UserPrototypeEditor
 */
define(['jquery', 'underscore', 'nmodule/webEditors/rc/fe/baja/compat/RelevantStringEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils'], function ($, _, StringEditor, spaceUtils, subscriberUtils) {
  'use strict';

  var resolveService = spaceUtils.resolveService,
      leaseWhenNeeded = subscriberUtils.leaseWhenNeeded,
      getUserPrototypes = leaseWhenNeeded(function (base) {
    return resolveService('baja:UserService', base).then(function (userService) {
      return userService.get('userPrototypes');
    });
  });
  /**
   * Editor for a user prototype name.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/UserPrototypeEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/StringEditor
   */

  var UserPrototypeEditor = function UserPrototypeEditor(params) {
    StringEditor.call(this, $.extend({
      formFactor: 'mini',
      keyName: 'UserPrototypeEditor'
    }, params));
  };

  UserPrototypeEditor.prototype = Object.create(StringEditor.prototype);
  UserPrototypeEditor.prototype.constructor = UserPrototypeEditor;
  /**
   * Attempt to resolve all available user prototypes from the current
   * UserService. If the UserService cannot be found on the station, an empty
   * array will be resolved.
   *
   * @private
   * @returns {Promise} promise to be resolved with an array of
   * slot names from the UserService's prototype container, or an
   * empty array
   */

  UserPrototypeEditor.prototype.$getAvailablePrototypeNames = function () {
    return getUserPrototypes().then(function (prots) {
      return _.map(prots.getSlots().is('baja:User', 'baja:UserPrototype').toArray(), String);
    }, function () {
      return [];
    });
  };
  /**
   * Set up the string editor with a `datalist` containing the names of all
   * available prototypes on the current UserService.
   *
   * @param {jQuery} dom
   * @returns {Promise}
   */


  UserPrototypeEditor.prototype.doInitialize = function (dom) {
    var that = this,
        args = arguments;
    return that.$getAvailablePrototypeNames().then(function (prototypes) {
      that.properties().add('datalist', prototypes.join(';'));
      return StringEditor.prototype.doInitialize.apply(that, args);
    });
  };

  return UserPrototypeEditor;
});
