function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/util/UserPasswordEditor
 */
define(['baja!', 'baja!baja:PasswordCache,' + 'baja:PasswordAuthenticationScheme,baja:User,' + 'baja:AbsTime', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/ConfirmPasswordEditor', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/spaceUtils', 'nmodule/webEditors/rc/fe/baja/util/subscriberUtils', 'nmodule/webEditors/rc/servlets/password', 'lex!baja'], function (baja, types, $, Promise, _, ConfirmPasswordEditor, BaseEditor, spaceUtils, subscriberUtils, password, lexs) {
  'use strict';

  var resolveService = spaceUtils.resolveService,
      leaseWhenNeeded = subscriberUtils.leaseWhenNeeded,
      getAuthenticationSchemes = leaseWhenNeeded(function (base) {
    return resolveService('baja:AuthenticationService', base).then(function (authenticationService) {
      return authenticationService.get('authenticationSchemes');
    });
  }),
      SHOULD_VALIDATE = BaseEditor.SHOULD_VALIDATE;
  /** @param {String} err */

  function reject(err) {
    return Promise.reject(new Error(err));
  }

  function getPasswordConfig(user, base) {
    return getAuthenticationSchemes(base).then(function (authenticationSchemes) {
      var schemeName = user.get('authenticationSchemeName'); //NCCB-18386

      return baja.Ord.make({
        base: authenticationSchemes.getNavOrd(),
        child: 'slot:' + schemeName + '/globalPasswordConfiguration'
      }).get({
        lease: true
      });
    });
  }
  /**
   * @class
   * @alias module:nmodule/webEditors/rc/wb/util/UserPasswordEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */


  var UserPasswordEditor = function UserPasswordEditor(params) {
    var that = this;
    ConfirmPasswordEditor.call(that, $.extend({}, {
      keyName: 'UserPasswordEditor'
    }, params));
  };

  UserPasswordEditor.prototype = Object.create(ConfirmPasswordEditor.prototype);
  UserPasswordEditor.prototype.constructor = UserPasswordEditor;
  /**
   * Get the `baja:User` the loaded password belongs to.
   *
   * @private
   * @returns {Promise} promise to be resolved with a `User`, or
   * rejected if the password does not belong to a
   * `baja:PasswordCache` that belongs to a `baja:User`.
   */

  UserPasswordEditor.prototype.$getUser = function () {
    var complex = this.getComplex();

    if (!complex) {
      return reject('UserPasswordEditor only works as a ComplexSlotEditor');
    }

    if (!baja.hasType(complex, 'baja:PasswordCache')) {
      return reject('password must belong to a PasswordCache');
    }

    var user = complex.getParent();

    if (!baja.hasType(user, 'baja:User')) {
      return reject('authenticator must belong to a User');
    }

    return Promise.resolve(user);
  };
  /**
   * Resolve the `baja:GlobalPasswordConfiguration` that applies to the backing
   * `User`, as configured by the `authenticationSchemeName` slot on the user.
   *
   * @private
   * @returns {Promise} promise to be resolved with the password config,
   * or rejected if it could not be found
   */


  UserPasswordEditor.prototype.$getPasswordConfig = function () {
    return Promise.all([this.$getUser(), this.getOrdBase()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          user = _ref2[0],
          ordBase = _ref2[1];

      return getPasswordConfig(user, ordBase);
    });
  };
  /**
   * Does not actually load the password into the DOM. This only verifies that
   * the loaded password belongs to a `baja:User`; this means that in order
   * to function, this `UserPasswordEditor` must be instantiated as a
   * `ComplexSlotEditor`. The backing `Complex` instance *must* be a
   * `baja:PasswordCache` or subclass that belongs to a
   * `baja:User`.
   *
   * @param {baja.Simple} password
   * @returns {Promise} promise to be resolved if the password actually
   * is a `baja:Password` that correctly belongs to a `User`.
   */


  UserPasswordEditor.prototype.doLoad = function (password) {
    var that = this;

    if (!baja.hasType(password, 'baja:Password')) {
      return reject('baja:Password required');
    }

    return Promise.all([this.$getUser(), ConfirmPasswordEditor.prototype.doLoad.call(this, password)]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
          user = _ref4[0];

      /**
       * when adding a new user, we want the password to always be validated.
       * when editing an existing user, we only want to validate the password
       * if it has been modified. since new users are not mounted yet, we set
       * shouldValidate accordingly, which will be respected by UserManager.
       */
      that.properties().add(SHOULD_VALIDATE, !user.isMounted());
    });
  };
  /**
   * Saving a `UserPasswordEditor` only makes sense when editing a password that
   * belongs to a User. Since BajaScript will not encode a `baja:Password`
   * (nor should it), the save operation will be delegated to the
   * `ChangeUserPasswordServlet` instead.
   *
   * @see module:nmodule/webEditors/rc/fe/baja/ComplexSlotEditor
   * @see module:nmodule/webEditors/rc/servlets/password
   * @returns {Promise}
   */


  UserPasswordEditor.prototype.saveToComplex = function (pw, params) {
    return Promise.all([this.$getUser(), this.getOrdBase()]).then(function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 2),
          user = _ref6[0],
          base = _ref6[1];

      return password.changePasswords([user.getName()], [pw.encodeToString()], base);
    });
  };

  return UserPasswordEditor;
});
